/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.stock;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AbilityConditionWithSource;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.modifiers.AttackModifier;
import open.batoru.data.ability.stock.StockAbility;
import open.batoru.parsers.LanguageParser;

public final class StockAbilityAssassin
extends StockAbility {
    private AbilityConditionWithSource addCondition;
    private static Pattern PATTERN_ASSASSIN_TEXT;

    public StockAbilityAssassin() {
        this(null, null);
    }

    public StockAbilityAssassin(AbilityConditionWithSource addCondition) {
        this(addCondition, null);
    }

    public StockAbilityAssassin(StockAbilityAssassin sourceAbilityRef) {
        this(sourceAbilityRef.addCondition, sourceAbilityRef);
    }

    private StockAbilityAssassin(AbilityConditionWithSource addCondition, StockAbilityAssassin sourceAbilityRef) {
        this.addCondition = addCondition;
        ConstantAbility ability = new ConstantAbility(new AttackModifier(2));
        this.setAbility(ability);
        String textAssassin = LanguageParser.getString("CARD_TEXT_STOCK_ABILITY_ASSASSIN");
        if (addCondition == null) {
            this.setAbilityDescription(textAssassin);
        } else {
            ability.setOnAbilityInit(() -> {
                Matcher matcher;
                Ability abilityRef = sourceAbilityRef == null ? ability : sourceAbilityRef.getAbility();
                String sourceDescription = DescriptionParser.getAbilityDescription(abilityRef.getSourceAttachAbility() != null ? abilityRef.getSourceAttachAbility() : abilityRef);
                int tokenStart = textAssassin.indexOf(91);
                String textConstHeader = textAssassin.substring(0, tokenStart);
                String textLancerStart = textAssassin.substring(tokenStart, textAssassin.length() - 2);
                if (PATTERN_ASSASSIN_TEXT == null) {
                    PATTERN_ASSASSIN_TEXT = Pattern.compile(Pattern.quote(textLancerStart) + "(.*?)]]");
                }
                this.setAbilityDescription((String)(!(matcher = PATTERN_ASSASSIN_TEXT.matcher(sourceDescription)).find() ? textAssassin : textConstHeader + matcher.group()));
            });
            ability.setCondition(this::onConstEffCond);
        }
    }

    private AbilityCondition.ConditionState onConstEffCond() {
        CardIndex source = this.getAbility().getSourceCardIndex();
        return source.getIndexedInstance().getOppositeSIGNI() != null && this.addCondition.getState(source.getIndexedInstance().getOppositeSIGNI()) == AbilityCondition.ConditionState.OK ? AbilityCondition.ConditionState.OK : AbilityCondition.ConditionState.BAD;
    }

    @Override
    public void dispose() {
        this.addCondition = null;
        super.dispose();
    }
}

