/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.stock;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.DataTable;
import open.batoru.data.ModifiableFlag;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ConstantEffect;
import open.batoru.data.ability.stock.StockAbility;
import open.batoru.game.FieldData;
import open.batoru.game.FieldZoneCrossIndicator;
import open.batoru.game.ZoneSIGNI;
import open.batoru.ui.FX;

public final class StockAbilityCross
extends StockAbility {
    private final LeftOf leftOf;
    private final RightOf rightOf;

    public StockAbilityCross(RightOf rightOf) {
        this(rightOf, null);
    }

    public StockAbilityCross(LeftOf leftOf) {
        this(null, leftOf);
    }

    public StockAbilityCross(RightOf rightOf, LeftOf leftOf) {
        TargetFilter filter = new TargetFilter().own().SIGNI();
        if (rightOf != null && leftOf != null) {
            filter = filter.or(new TargetFilter().left().withName(rightOf.names), new TargetFilter().right().withName(leftOf.names));
        } else if (rightOf != null) {
            filter = filter.left().withName(rightOf.names);
        } else if (leftOf != null) {
            filter = filter.right().withName(leftOf.names);
        }
        this.rightOf = rightOf;
        this.leftOf = leftOf;
        CrossAbility ability = new CrossAbility(filter);
        filter.setSourceAbility(ability);
        this.setAbility(ability);
    }

    public RightOf getRightOf() {
        return this.rightOf;
    }

    public LeftOf getLeftOf() {
        return this.leftOf;
    }

    public record RightOf(String[] names) {
    }

    public record LeftOf(String[] names) {
    }

    private static class CrossAbility
    extends Ability
    implements ConstantEffect {
        private TargetFilter filter;
        private CardIndex[] cachedLastCardIndexOther = new CardIndex[2];

        public CrossAbility(TargetFilter filter) {
            this.filter = filter;
        }

        @Override
        public int getPriority() {
            return -1;
        }

        @Override
        public void update() {
            GameConst.CardLocation location;
            boolean isTransient = this.getSourceCardIndex().getIndexedInstance().isState(2048);
            GameConst.CardLocation cardLocation = location = !isTransient ? this.getSourceCardIndex().getLocation() : this.getSourceCardIndex().getPreTransientLocation();
            if (!GameConst.CardLocation.isSIGNI(location)) {
                return;
            }
            ZoneSIGNI zoneSIGNI = (ZoneSIGNI)FieldData.getZoneByLocation(this.getSourceCardIndex().getCurrentOwnerSafe(), location);
            DataTable data = this.filter.getExportedData(true);
            ModifiableFlag modState = this.getSourceCardIndex().getIndexedInstance().getCardStateFlags();
            for (FieldZoneCrossIndicator.CrossPosition position : FieldZoneCrossIndicator.CrossPosition.values()) {
                GameConst.CardLocation locationCrossOther;
                int flagFilterHint;
                int n = flagFilterHint = position == FieldZoneCrossIndicator.CrossPosition.LEFT ? 4 : 8;
                if ((this.filter.getHintFilterFlags() & flagFilterHint) == 0) continue;
                int flagCrossedState = position == FieldZoneCrossIndicator.CrossPosition.LEFT ? 131072 : 262144;
                boolean isCrossed = (modState.getValue() & flagCrossedState) != 0;
                GameConst.CardLocation cardLocation2 = locationCrossOther = position == FieldZoneCrossIndicator.CrossPosition.LEFT ? GameConst.CardLocation.getLeftSIGNILocation(location) : GameConst.CardLocation.getRightSIGNILocation(location);
                if (!isTransient && zoneSIGNI.getZoneCrossIndicator(position) == null) {
                    FX.run(() -> zoneSIGNI.installZoneCrossIndicator(position));
                }
                if (locationCrossOther != null) {
                    CardIndex lastCardIndexOther = this.cachedLastCardIndexOther[position.ordinal()];
                    CardIndex cardIndexOther = data.stream().filter(other -> other.getLocation() == locationCrossOther).findFirst().orElse(lastCardIndexOther != null && lastCardIndexOther.getIndexedInstance() != null && lastCardIndexOther.getPreTransientLocation() == locationCrossOther && lastCardIndexOther.getIndexedInstance().isState(2048) ? lastCardIndexOther : null);
                    if (cardIndexOther != null) {
                        this.cachedLastCardIndexOther[position.ordinal()] = cardIndexOther;
                        if (this.isDisabled() && cardIndexOther.getIndexedInstance().getAbilityList().getFirst().isDisabled()) {
                            if (!isCrossed) continue;
                            modState.removeValue(flagCrossedState);
                            continue;
                        }
                        if (isCrossed) continue;
                        modState.addValue(flagCrossedState);
                        continue;
                    }
                    if (!isCrossed) continue;
                    modState.removeValue(flagCrossedState);
                    continue;
                }
                if (isCrossed) {
                    modState.removeValue(flagCrossedState);
                }
                FX.run(() -> {
                    FieldZoneCrossIndicator crossIndicator = zoneSIGNI.getZoneCrossIndicator(position);
                    if (crossIndicator != null) {
                        crossIndicator.setState(FieldZoneCrossIndicator.CrossState.DISABLED);
                    }
                });
            }
        }

        @Override
        public void disable() {
            this.update();
            super.disable();
        }

        @Override
        public void enable() {
            this.update();
            super.enable();
        }

        @Override
        public void dispose() {
            this.filter = null;
            this.cachedLastCardIndexOther = null;
            super.dispose();
        }
    }
}

