/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.stock;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AbilityConditionNoSource;
import open.batoru.data.ability.AbilityConditionWithSource;
import open.batoru.data.ability.AbilityEffectWithSource;
import open.batoru.data.ability.stock.StockAbility;
import open.batoru.data.ability.stock.StockAbilitySLancer;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.parsers.LanguageParser;

public final class StockAbilityLancer
extends StockAbility {
    private AbilityConditionWithSource addCondition;
    private static Pattern PATTERN_LANCER_TEXT;

    public StockAbilityLancer() {
        this(null, null);
    }

    public StockAbilityLancer(AbilityConditionWithSource addCondition) {
        this(addCondition, null);
    }

    public StockAbilityLancer(StockAbilityLancer sourceAbilityRef) {
        this(sourceAbilityRef.addCondition, sourceAbilityRef);
    }

    private StockAbilityLancer(AbilityConditionWithSource addCondition, StockAbilityLancer sourceAbilityRef) {
        this.addCondition = addCondition;
        LancerAbility ability = new LancerAbility(this::onLancerEffCond, this::onLancerEff);
        this.setAbility(ability);
        String textLancer = LanguageParser.getString("CARD_TEXT_STOCK_ABILITY_LANCER");
        if (addCondition == null) {
            this.setAbilityDescription(textLancer);
        } else {
            ability.setOnAbilityInit(() -> {
                Matcher matcher;
                Ability abilityRef = sourceAbilityRef == null ? ability : sourceAbilityRef.getAbility();
                String sourceDescription = DescriptionParser.getAbilityDescription(abilityRef.getSourceAttachAbility() != null ? abilityRef.getSourceAttachAbility() : abilityRef);
                int tokenStart = textLancer.indexOf(91);
                String textConstHeader = textLancer.substring(0, tokenStart);
                String textLancerStart = textLancer.substring(tokenStart, textLancer.length() - 2);
                if (PATTERN_LANCER_TEXT == null) {
                    PATTERN_LANCER_TEXT = Pattern.compile(Pattern.quote(textLancerStart) + "(.*?)]]");
                }
                this.setAbilityDescription((String)(!(matcher = PATTERN_LANCER_TEXT.matcher(sourceDescription)).find() ? textLancer : textConstHeader + matcher.group()));
            });
        }
        ability.setOnAbilityEnabled(cardIndex -> cardIndex.getSourceCard3D().getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(UtilTextureLayer.TextureType.LANCER)));
        ability.setOnAbilityDisabled(cardIndex -> cardIndex.getSourceCard3D().getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.LANCER.getAlias()));
    }

    private AbilityCondition.ConditionState onLancerEffCond() {
        if (EffectBucket.getLastEvent().getSourceCardIndex() != this.getAbility().getSourceCardIndex() || EffectBucket.getLastEvent().getSourceAbility() != null) {
            return AbilityCondition.ConditionState.BAD;
        }
        for (Ability ability : this.getAbility().getSourceCardIndex().getIndexedInstance().getAbilityList()) {
            if (!(ability.getSourceStockAbility() instanceof StockAbilitySLancer) || ability.isMuted() || ability.isDisabled()) continue;
            return AbilityCondition.ConditionState.BAD;
        }
        EffectBucket sourceBucket = Game.getCurrentGame().getGameRules().getEffectProcessor().getSourceBucket(this.getAbility());
        for (int i = sourceBucket.getCompletedEffectsNum(); i < sourceBucket.getAbilitiesNum(); ++i) {
            Ability ability = sourceBucket.getAbilityList().get(i);
            if (!(ability.getSourceStockAbility() instanceof StockAbilityLancer) || ability.getSourceCardIndex() != this.getAbility().getSourceCardIndex()) continue;
            return AbilityCondition.ConditionState.BAD;
        }
        return this.addCondition == null || this.addCondition.getState(EffectBucket.getLastEvent().getCallerCardIndex()) == AbilityCondition.ConditionState.OK ? AbilityCondition.ConditionState.OK : AbilityCondition.ConditionState.BAD;
    }

    private void onLancerEff(CardIndex caller) {
        this.getAbility().getSourceCardIndex().getIndexedInstance().crush(this.getAbility().getSourceCardIndex().getIndexedInstance().getOpponent());
    }

    @Override
    public void dispose() {
        this.addCondition = null;
        super.dispose();
    }

    static class LancerAbility
    extends Ability {
        public LancerAbility(AbilityConditionNoSource condition, AbilityEffectWithSource effect) {
            this.setEffect(effect);
            this.setCondition(condition);
            this.setActiveEvent(GameConst.GameEventId.BANISH);
        }
    }
}

