/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.stock;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.CardAbilities;
import open.batoru.data.ability.stock.StockAbility;
import open.batoru.data.ability.stock.StockAbilityLancer;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.parsers.LanguageParser;

public final class StockAbilitySLancer
extends StockAbility {
    public StockAbilitySLancer() {
        StockAbilityLancer.LancerAbility ability = new StockAbilityLancer.LancerAbility(this::onLancerEffCond, this::onLancerEff);
        this.setAbility(ability);
        this.setAbilityDescription(LanguageParser.getString("CARD_TEXT_STOCK_ABILITY_SLANCER"));
        ability.setOnAbilityEnabled(cardIndex -> cardIndex.getSourceCard3D().getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(UtilTextureLayer.TextureType.SLANCER)));
        ability.setOnAbilityDisabled(cardIndex -> cardIndex.getSourceCard3D().getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SLANCER.getAlias()));
    }

    private AbilityCondition.ConditionState onLancerEffCond() {
        if (EffectBucket.getLastEvent().getSourceCardIndex() != this.getAbility().getSourceCardIndex() || EffectBucket.getLastEvent().getSourceAbility() != null) {
            return AbilityCondition.ConditionState.BAD;
        }
        EffectBucket sourceBucket = Game.getCurrentGame().getGameRules().getEffectProcessor().getSourceBucket(this.getAbility());
        for (int i = sourceBucket.getCompletedEffectsNum(); i < sourceBucket.getAbilitiesNum(); ++i) {
            Ability ability = sourceBucket.getAbilityList().get(i);
            if (!(ability.getSourceStockAbility() instanceof StockAbilitySLancer) || ability.getSourceCardIndex() != this.getAbility().getSourceCardIndex()) continue;
            return AbilityCondition.ConditionState.BAD;
        }
        return AbilityCondition.ConditionState.OK;
    }

    private void onLancerEff(CardIndex caller) {
        CardIndex cardIndexSource = this.getAbility().getSourceCardIndex();
        if (CardAbilities.getLifeClothCount(cardIndexSource.getIndexedInstance().getOpponent()) > 0) {
            cardIndexSource.getIndexedInstance().crush(cardIndexSource.getIndexedInstance().getOpponent());
        } else {
            cardIndexSource.getIndexedInstance().damage(cardIndexSource.getIndexedInstance().getOpponent());
        }
    }
}

