/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.stock;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionTrash;
import open.batoru.core.gameplay.actions.override.OverrideAction;
import open.batoru.core.gameplay.actions.override.OverrideActionList;
import open.batoru.core.gameplay.rulechecks.CardRuleCheckData;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.data.ability.modifiers.RuleCheckModifier;
import open.batoru.data.ability.stock.StockAbility;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.parsers.LanguageParser;

public final class StockAbilityShoot
extends StockAbility {
    public StockAbilityShoot() {
        ConstantAbility ability = new ConstantAbility(new RuleCheckModifier<OverrideAction, CardRuleCheckData>(CardRuleCheckRegistry.CardRuleCheckType.ACTION_OVERRIDE, data -> new OverrideAction(GameConst.GameEventId.BANISH, OverrideAction.OverrideScope.SOURCE, 4, this::onConstEffModOverrideCond, this::onConstEffModOverrideHandler)));
        this.setAbility(ability);
        this.setAbilityDescription(LanguageParser.getString("CARD_TEXT_STOCK_ABILITY_SHOOT"));
        ability.setOnAbilityEnabled(cardIndex -> cardIndex.getSourceCard3D().getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(UtilTextureLayer.TextureType.SHOOT)));
        ability.setOnAbilityDisabled(cardIndex -> cardIndex.getSourceCard3D().getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SHOOT.getAlias()));
    }

    private boolean onConstEffModOverrideCond(CardIndex cardIndex, GameEvent event, Ability sourceAbilityRC) {
        return event.getSourceAbility() == null && !sourceAbilityRC.getSourceCardIndex().getIndexedInstance().isOwnCard(event.getCallerCardIndex()) && !event.getCaller().isState(8) && event.getCaller().getCardReference().getType() != CardConst.CardType.RESONA;
    }

    private void onConstEffModOverrideHandler(OverrideActionList list, Ability sourceAbilityRC) {
        list.addAction(new ActionTrash(list.getSourceEvent().getCallerCardIndex()));
    }
}

