/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.stock;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ModifiableDouble;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.modifiers.ModifiableValueModifier;
import open.batoru.data.ability.stock.StockPlayerAbilityToken;
import open.batoru.game.PlayerField;
import open.batoru.game.gfx.GFXZoneUnderIndicator;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public final class StockPlayerAbilityLimitUpper
extends StockPlayerAbilityToken {
    private GFXZoneUnderIndicator gfx;

    public StockPlayerAbilityLimitUpper() {
        super("WX24-D1-TK1", 1);
        ConstantAbility ability = new ConstantAbility(new ModifiableValueModifier(this::onConstEffModGetSample, () -> 2.0));
        ability.setOnAbilityInit(() -> {
            PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(ability.getSourceAttachPlayerRole());
            if (Game.getCurrentGame().getPlayerGameData(ability.getSourceAttachPlayerRole()).getPlayerAbilities().stream().anyMatch(playerAbility -> playerAbility.getSourceStockAbility() instanceof StockPlayerAbilityLimitUpper) || !field.getLRIGAssistZoneLeft().getZoneCardList().isEmpty() || !field.getLRIGAssistZoneRight().getZoneCardList().isEmpty()) {
                ability.disable();
            }
        });
        ability.setOnAbilityEnabled(cardIndex -> {
            if (this.gfx != null) {
                return;
            }
            this.gfx = new GFXZoneUnderIndicator(ability.getSourceAttachPlayerRole(), GameConst.CardLocation.LRIG, "limit_up");
            this.gfx.attach();
        });
        ability.setOnAbilityDisabled(cardIndex -> {
            if (this.gfx == null) {
                return;
            }
            this.gfx.detach();
            this.gfx = null;
        });
        this.setAbility(ability);
        this.setAbilityDescription(LanguageParser.getString("CARD_TEXT_STOCK_ABILITY_LIMIT_UPPER"));
    }

    private ModifiableDouble onConstEffModGetSample(CardIndex cardIndex) {
        Game.GamePlayerRole rolePlayer = this.getAbility().getSourceAttachPlayerRole();
        CardIndex cardIndexLRIG = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getLRIGZone().getTopCard().getCardIndex();
        return cardIndexLRIG.getIndexedInstance().getLevel().getValue() >= 3 ? cardIndexLRIG.getIndexedInstance().getLimit() : null;
    }

    @Override
    public void dispose() {
        this.gfx = null;
        super.dispose();
    }
}

