/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.stock;

import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.util.Duration;
import open.batoru.ImageCache;
import open.batoru.UtilRandom;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.CardAbilities;
import open.batoru.data.ability.stock.StockPlayerAbilityToken;
import open.batoru.game._3d.Plane;
import open.batoru.game.gfx.GFX;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UtilDispose;

public final class StockPlayerAbilityMikomikoBodyguard
extends StockPlayerAbilityToken {
    private GFXMikomikoBodyguard gfx;

    public StockPlayerAbilityMikomikoBodyguard() {
        super("WXDi-P12-TK01B", 2);
        AutoAbility ability = new AutoAbility(GameConst.GameEventId.PHASE_START, this::onAutoEff);
        ability.setCondition(this::onAutoEffCond);
        this.setAbility(ability);
        this.setAbilityDescription(LanguageParser.getString("CARD_TEXT_STOCK_ABILITY_MIKOMIKO_BODYGUARD"));
        ability.setOnAbilityEnabled(cardIndex -> {
            if (this.gfx != null) {
                return;
            }
            this.gfx = new GFXMikomikoBodyguard(cardIndex.getCurrentOwnerSafe());
            this.gfx.onAttached();
        });
        ability.setOnAbilityDisabled(cardIndex -> {
            if (this.gfx == null) {
                return;
            }
            this.gfx.onDetached();
            this.gfx = null;
        });
    }

    private AbilityCondition.ConditionState onAutoEffCond() {
        return CardAbilities.getTurnPlayer() == this.getAbility().getSourceAttachPlayerRole() && CardAbilities.getCurrentPhase() == GameConst.GamePhase.END ? AbilityCondition.ConditionState.OK : AbilityCondition.ConditionState.BAD;
    }

    private void onAutoEff(CardIndex caller) {
        CardIndex cardIndex = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getAbility().getSourceAttachPlayerRole()).getLRIGZone().getTopCard().getCardIndex().getIndexedInstance().discard(this.getAbility().getSourceAttachPlayerRole(), 1).get();
        if (cardIndex != null) {
            CardAbilities.removePlayerAbility(this.getAbility());
        }
    }

    @Override
    public void dispose() {
        this.gfx = null;
        super.dispose();
    }

    private static class GFXMikomikoBodyguard
    extends GFX {
        private Plane plane;
        private Plane planeHandLeft;
        private Plane planeHandRight;
        private final Game.GamePlayerRole rolePlayer;
        private Timeline timeline;

        public GFXMikomikoBodyguard(Game.GamePlayerRole rolePlayer) {
            this.rolePlayer = rolePlayer;
        }

        @Override
        protected void onAttached() {
            this.plane = new Plane(163, 128, ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("mikomiko/oshi" + UtilRandom.get(1, 2))));
            this.plane.setMouseTransparent(true);
            this.plane.setTransX(349 + UtilRandom.get(-270, 720));
            this.plane.setTransY(675.0);
            this.plane.setTransZ(-40.0);
            this.planeHandLeft = new Plane(63, 78, ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("mikomiko/hand_left")));
            this.planeHandLeft.setTransX(-100.0);
            this.planeHandRight = new Plane(63, 78, this.planeHandLeft.getMaterial().getDiffuseMap());
            this.planeHandRight.setTransX(100.0);
            this.planeHandRight.getMesh().getTexCoords().setAll(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f});
            this.plane.getChildren().addAll((Object[])new Node[]{this.planeHandLeft, this.planeHandRight});
            UtilDispose.TEMP.setOnDisposed((Node)this.plane, () -> {
                this.plane.getMaterial().setDiffuseMap(null);
                this.planeHandLeft.getMaterial().setDiffuseMap(null);
                this.planeHandRight.getMaterial().setDiffuseMap(null);
                this.timeline.stop();
                this.timeline.getKeyFrames().clear();
            });
            UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getChildren().add((Object)this.plane);
            this.playAnimation();
        }

        @Override
        protected void onDetached() {
            this.timeline.stop();
            UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getChildren().remove((Object)this.plane);
        }

        private void playAnimation() {
            this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.planeHandLeft.translateYProperty(), (Object)-20, Interpolator.DISCRETE)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.planeHandRight.translateYProperty(), (Object)20, Interpolator.DISCRETE)}), new KeyFrame(Duration.millis((double)2000.0), new KeyValue[]{new KeyValue((WritableValue)this.planeHandLeft.translateYProperty(), (Object)0, Interpolator.DISCRETE)}), new KeyFrame(Duration.millis((double)2000.0), new KeyValue[]{new KeyValue((WritableValue)this.planeHandRight.translateYProperty(), (Object)0, Interpolator.DISCRETE)}), new KeyFrame(Duration.millis((double)3000.0), new KeyValue[]{new KeyValue((WritableValue)this.planeHandLeft.translateYProperty(), (Object)20, Interpolator.DISCRETE)}), new KeyFrame(Duration.millis((double)3000.0), new KeyValue[]{new KeyValue((WritableValue)this.planeHandRight.translateYProperty(), (Object)-20, Interpolator.DISCRETE)}), new KeyFrame(Duration.millis((double)4000.0), new KeyValue[]{new KeyValue((WritableValue)this.planeHandLeft.translateYProperty(), (Object)0, Interpolator.DISCRETE)}), new KeyFrame(Duration.millis((double)4000.0), new KeyValue[]{new KeyValue((WritableValue)this.planeHandRight.translateYProperty(), (Object)0, Interpolator.DISCRETE)}), new KeyFrame(Duration.millis((double)5000.0), new KeyValue[]{new KeyValue((WritableValue)this.planeHandLeft.translateYProperty(), (Object)-20, Interpolator.DISCRETE)}), new KeyFrame(Duration.millis((double)5000.0), new KeyValue[]{new KeyValue((WritableValue)this.planeHandRight.translateYProperty(), (Object)-20, Interpolator.DISCRETE)}), new KeyFrame(Duration.millis((double)6000.0), new KeyValue[]{new KeyValue((WritableValue)this.planeHandLeft.translateYProperty(), (Object)40, Interpolator.DISCRETE)}), new KeyFrame(Duration.millis((double)6000.0), new KeyValue[]{new KeyValue((WritableValue)this.planeHandRight.translateYProperty(), (Object)40, Interpolator.DISCRETE)})});
            this.timeline.setRate((double)UtilRandom.get(8, 20) * 0.1);
            this.timeline.setCycleCount(-1);
            this.timeline.play();
        }
    }
}

