/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.scene.paint.Color;
import open.batoru.UtilRandom;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.control.UtilCardPlayableControl;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.SpellAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.game.FieldZone;
import open.batoru.game.FieldZoneArrow;
import open.batoru.game.PlayerField;
import open.batoru.game.PlayerHand;
import open.batoru.game.Zone;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.textures.CostTextureLayer;
import open.batoru.game.gfx.GFXTrackedCardDecorator;

public class FieldVisualStateCoordinator
implements Disposable {
    private final PlayerField field;
    private final Game.GamePlayerRole rolePlayer;
    private final Map<Zone, Integer> cacheCostToAttackTextureLayers = new WeakHashMap<Zone, Integer>();
    private ArrayList<GFXTrackedCardDecorator.GFXTracker> gfxTrackers;

    public FieldVisualStateCoordinator(PlayerField field) {
        this.field = field;
        this.rolePlayer = Zone.getZoneOwner(field.getLRIGZone());
    }

    public void update() {
        this.updateSIGNIStatus();
        this.updateLRIGStatus();
        this.updateHandStatus();
        if (this.gfxTrackers != null) {
            for (GFXTrackedCardDecorator.GFXTracker gfxTracker : this.gfxTrackers) {
                gfxTracker.update();
            }
        }
    }

    public void addGFXTracker(GFXTrackedCardDecorator.GFXTracker gfxTracker) {
        if (this.gfxTrackers == null) {
            this.gfxTrackers = new ArrayList();
        }
        this.gfxTrackers.add(gfxTracker);
    }

    public void removeGFXTracker(GFXTrackedCardDecorator.GFXTracker gfxTracker) {
        if (this.gfxTrackers != null && this.gfxTrackers.remove(gfxTracker)) {
            gfxTracker.clearAll();
            if (this.gfxTrackers.isEmpty()) {
                this.gfxTrackers = null;
            }
        }
    }

    private void updateSIGNIStatus() {
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            ZoneSIGNI zoneSIGNI = this.field.getSIGNIZone(zonePosition);
            if (!zoneSIGNI.getNode().isVisible()) continue;
            FieldZoneArrow zoneArrow = zoneSIGNI.getZoneArrow();
            if (!FieldZone.isOccupied(zoneSIGNI)) {
                this.cacheCostToAttackTextureLayers.remove(zoneSIGNI);
                zoneArrow.setVisible(true);
                continue;
            }
            this.processAttackCosts(zoneSIGNI);
            CardIndex cardIndex = zoneSIGNI.getTopCard().getCardIndex();
            zoneArrow.setVisible(AbilityCostList.canPayDataCostLists(((AbilityCost)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.COST_TO_ATTACK).check(cardIndex)).getSourceCostList().getSourceDataCostLists()) && (cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ATTACK).check(cardIndex) == RuleCheck.RuleCheckState.OK || cardIndex.getIndexedInstance().isState(16384)) && Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.rolePlayer).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_ATTACK).check(this.rolePlayer, cardIndex, new Object[0]) == RuleCheck.RuleCheckState.OK);
        }
    }

    private void updateLRIGStatus() {
        this.processAttackCosts(this.field.getLRIGZone());
        if (FieldZone.isOccupied(this.field.getLRIGAssistZoneLeft())) {
            this.processAttackCosts(this.field.getLRIGAssistZoneLeft());
        }
        if (FieldZone.isOccupied(this.field.getLRIGAssistZoneRight())) {
            this.processAttackCosts(this.field.getLRIGAssistZoneRight());
        }
    }

    private void processAttackCosts(Zone zone) {
        CardIndex cardIndex = zone.getTopCard().getCardIndex();
        List<AbilityCostList> dataCostListsAttack = ((AbilityCost)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.COST_TO_ATTACK).check(cardIndex)).getSourceCostList().getSourceDataCostLists();
        int newHash = FieldVisualStateCoordinator.deepCostHash(cardIndex, dataCostListsAttack);
        if (this.cacheCostToAttackTextureLayers.getOrDefault(zone, -1) != newHash) {
            this.cacheCostToAttackTextureLayers.put(zone, newHash);
            cardIndex.getSourceCard3D().getCardMeshFace().removeTextureLayer("atk-cost");
            if (!dataCostListsAttack.isEmpty()) {
                CostTextureLayer costTextureLayer = new CostTextureLayer("atk-cost");
                for (AbilityCostList costList : dataCostListsAttack) {
                    for (AbilityCost cost : costList.getDataArray()) {
                        costTextureLayer.addIcon(cost);
                    }
                }
                cardIndex.getSourceCard3D().getCardMeshFace().addTextureLayer(costTextureLayer);
            }
        }
    }

    private static int deepCostHash(CardIndex cardIndex, List<AbilityCostList> dataCostListsAttack) {
        int hash = 1;
        hash = 31 * hash + cardIndex.getId();
        for (AbilityCostList costList : dataCostListsAttack) {
            for (AbilityCost cost : costList.getDataArray()) {
                int n;
                if (cost instanceof EnerCost) {
                    EnerCost enerCost = (EnerCost)cost;
                    n = enerCost.getCostString().getValue().hashCode();
                } else {
                    n = Integer.hashCode(cost.getCostMinCount());
                }
                hash = 31 * hash + n;
            }
        }
        return hash;
    }

    private void updateHandStatus() {
        if (!Game.getCurrentGame().isNeutralPerspectiveGame() && this.rolePlayer != Game.getCurrentGame().getPlayerRole()) {
            return;
        }
        PlayerHand hand = this.field.getHand();
        for (Card3D card3D : hand.getZoneCardList()) {
            CardIndex cardIndex = card3D.getCardIndex();
            if (cardIndex.getIndexedInstance() == null) continue;
            if (this.rolePlayer == Game.getCurrentGame().getPlayerRole() && Game.getCurrentGame().getGameRules().isOwnTurn() && Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase().getId() == GameConst.GamePhase.MAIN) {
                if (UtilCardPlayableControl.isPlayable(this.rolePlayer, cardIndex, null) == UtilCardPlayableControl.PlayableResult.OK) {
                    CardConst.CardType cardType = cardIndex.getCardReference().getType();
                    if (cardType == CardConst.CardType.SIGNI) {
                        card3D.glow(Color.GREEN);
                    } else {
                        SpellAbility.findSpellAbility(cardIndex).ifPresent(ability -> card3D.glow(ability.getReductionForcedPaymentMinCount() == 0 ? Color.ORANGE : Color.ORANGERED));
                    }
                } else {
                    card3D.removeGlow();
                }
            } else {
                card3D.removeGlow();
            }
            if (!cardIndex.getCardReference().canGuard()) continue;
            if (!cardIndex.getIndexedInstance().isState(2) || ((RuleCheck)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.rolePlayer).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_GUARD)).getRuleChecksNum() > 1 || cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_GUARD).check(cardIndex) == RuleCheck.RuleCheckState.BLOCK) {
                if (card3D.getShatter() != null) continue;
                card3D.shatter();
                card3D.getShatter().getChildren().forEach(child -> {
                    Group3D fragment = (Group3D)((Object)child);
                    fragment.setRotateX(UtilRandom.get(-2, 2));
                    fragment.setRotateY(UtilRandom.get(-2, 2));
                    fragment.setRotateZ(UtilRandom.get(-2, 2));
                });
                continue;
            }
            card3D.removeShatter();
        }
    }

    @Override
    public void dispose() {
    }
}

