/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Plane;
import open.batoru.game._3d.Vector3D;
import open.batoru.game.animations.AnimationTexturedMeshFlash;
import open.batoru.ui.UI;

public abstract class FieldZone
extends Zone
implements TargetFilter.Targetable,
Disposable {
    private Color defaultColor = Color.WHITE;
    private AnimationTexturedMeshFlash aniFlash;
    private final Plane zoneMesh;

    public FieldZone(double x, double y, int width, int height, ZoneType zoneType) {
        super(width, height);
        this.zoneMesh = new Plane(width, height, ImageCache.INSTANCE.getImage(ImageCache.getZoneTexturePath(zoneType)));
        this.getNode().getChildren().addAll((Object[])new Node[]{this.zoneMesh});
        this.getNode().setTranslate(x, y);
        this.installMouseEvents();
    }

    private void installMouseEvents() {
        this.zoneMesh.setOnMouseEntered(e -> this.installZoneHighlighter());
        this.zoneMesh.setOnMouseExited(e -> this.uninstallZoneHighlighter());
        this.getNode().setOnMouseClicked(e -> Game.getCurrentGame().getPlayerControl().onZoneClicked(this));
    }

    @Override
    protected Vector3D getCardOriginOffset(int i) {
        return new Vector3D(0.0, 0.0, (double)(-i) * 4.0);
    }

    @Override
    public void prepareRearrangeAnimation(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType, Zone.ZonePosition addPosition) {
        if (this.getLastModifiedIndex() == -1 || this.getZoneCardList().isEmpty() || this.getLastModifiedIndex() == this.getTotalCards()) {
            return;
        }
        int offset = rearrangeType == Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED && addPosition == Zone.ZonePosition.BOTTOM ? 1 : 0;
        ArrayList<Zone.RearrangeAnimationData> listData = new ArrayList<Zone.RearrangeAnimationData>();
        for (int i = this.getLastModifiedIndex(); i < this.getTotalCards(); ++i) {
            double end;
            Card3D card3D = this.getZoneCardList().get(i);
            double start = card3D.getTransZ();
            double diff = start - (end = this.getCardOriginOffset(i + offset).getZ());
            if (diff == 0.0) continue;
            listData.add(new Zone.RearrangeAnimationData(card3D, start, diff));
        }
        this.setOnRearrangeAnimationInterpolate(frac -> {
            for (Zone.RearrangeAnimationData data : listData) {
                data.card3D().setTransZ(data.start() - data.diff() * frac);
            }
        });
    }

    public final Plane getZoneMesh() {
        return this.zoneMesh;
    }

    public void setDefaultColor(Color color) {
        this.defaultColor = color;
        this.zoneMesh.getMaterial().setDiffuseColor(color);
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void flashZoneMesh(Color color) {
        if (this.aniFlash != null) {
            this.aniFlash.stop();
        }
        this.aniFlash = new AnimationTexturedMeshFlash(this.zoneMesh, this.defaultColor, color, true);
        this.aniFlash.play();
    }

    public void installZoneHighlighter() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByZoneFlip(this.isFlipped()).getZoneHighlighter().install(this);
    }

    public void uninstallZoneHighlighter() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByZoneFlip(this.isFlipped()).getZoneHighlighter().uninstall();
    }

    public static boolean isOccupied(FieldZone zone) {
        return zone.getNode().isVisible() && Card3D.isFaceUpOnField(zone.getTopCard());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.zoneMesh.setOnMouseEntered(null);
        this.zoneMesh.setOnMouseExited(null);
        this.getNode().setOnMouseClicked(null);
        this.zoneMesh.getMaterial().setDiffuseMap(null);
    }

    public static enum ZoneType {
        SIGNI,
        CHEER,
        LRIG,
        DECK_MAIN,
        DECK_LRIG,
        TRASH,
        TRASH_LRIG,
        CHECK,
        LRIG_KEY,
        KEY,
        ENER,
        LIFE_CLOTH;

    }
}

