/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;
import open.batoru.game._3d.TexturedMesh;
import open.batoru.game.animations.AnimationTexturedMeshFlash;

public class FieldZoneArrow
extends Group3D {
    private int oldAttackModifierFlags = -1;
    private final List<TexturedMesh> cacheArrowMeshes = new ArrayList<TexturedMesh>();

    public FieldZoneArrow() {
        this.updateAttackModifierFlags(0);
        this.setMouseTransparent(true);
    }

    public final void updateAttackModifierFlags(int flagsAttackModifier) {
        if (this.oldAttackModifierFlags == flagsAttackModifier) {
            return;
        }
        this.oldAttackModifierFlags = flagsAttackModifier;
        for (TexturedMesh mesh : this.cacheArrowMeshes) {
            this.getChildren().remove((Object)mesh);
        }
        this.cacheArrowMeshes.clear();
        if ((flagsAttackModifier & 1) != 0) {
            return;
        }
        Plane arrow1 = this.newArrow(flagsAttackModifier);
        this.getChildren().add((Object)arrow1);
        this.cacheArrowMeshes.add(arrow1);
        Plane deco1 = null;
        Plane deco2 = null;
        if ((flagsAttackModifier & 0x10) != 0) {
            deco1 = this.newArrowDecoration("forced");
            this.getChildren().add((Object)deco1);
            this.cacheArrowMeshes.add(deco1);
            deco1.setTransX(-32.0);
            deco2 = this.newArrowDecoration("forced");
            this.getChildren().add((Object)deco2);
            this.cacheArrowMeshes.add(deco2);
            deco2.setTransX(32.0);
        }
        if ((flagsAttackModifier & 4) != 0 || (flagsAttackModifier & 8) != 0) {
            Plane arrow2 = this.newArrow(flagsAttackModifier);
            this.getChildren().add((Object)arrow2);
            this.cacheArrowMeshes.add(arrow2);
            if (deco1 != null) {
                deco1.setTransX(deco1.getTransX() - 64.0);
            }
            arrow1.setTransX(-64.0);
            arrow2.setTransX(64.0);
            if (deco2 != null) {
                deco2.setTransX(deco2.getTransX() + 64.0);
            }
        }
        if ((flagsAttackModifier & 8) != 0) {
            Plane arrow3 = this.newArrow(flagsAttackModifier);
            this.getChildren().add((Object)arrow3);
            this.cacheArrowMeshes.add(arrow3);
        }
    }

    private Plane newArrow(int flagsAttackModifier) {
        String image = (flagsAttackModifier & 2) != 0 ? "direct" : "default";
        return this.newArrow(image);
    }

    private Plane newArrow(String image) {
        return new Plane(64, 34, image != null ? ImageCache.INSTANCE.getImage("textures/zones/arrows/" + image + ".png") : null, Plane.TextureTrimMode.UPPER_EDGE);
    }

    private Plane newArrowDecoration(String image) {
        return new Plane(64, 34, image != null ? ImageCache.INSTANCE.getImage("textures/zones/arrows/deco_" + image + ".png") : null);
    }

    public void flash(Color color) {
        for (TexturedMesh mesh : this.cacheArrowMeshes) {
            AnimationTexturedMeshFlash aniFlash = new AnimationTexturedMeshFlash(mesh, Color.WHITE, color, true);
            aniFlash.play();
        }
    }
}

