/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Cursor;
import open.batoru.ImageCache;
import open.batoru.core.Disposable;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.Ability;
import open.batoru.game._3d.Plane;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowAbilityInfo;

public class FieldZoneAttachedAbilitiesIndicator
extends Plane
implements Disposable {
    private final List<Ability> listAbilities = new ArrayList<Ability>();

    public FieldZoneAttachedAbilitiesIndicator() {
        super(72, ImageCache.INSTANCE.getImage(ImageCache.getBorderIconTexturePath(TargetFilter.TargetHint.ACTIVATE)));
        this.setCursor(Cursor.HAND);
        this.setPickOnBounds(true);
        this.setOnMouseClicked(e -> {
            OverlayWindowAbilityInfo window = new OverlayWindowAbilityInfo(this.listAbilities);
            window.setAlias("view" + String.valueOf(this));
            window.setIsInformationWindow();
            OverlayWindow.addToFieldOverlay(window);
            window.getConfirmButton().setOnAction(e2 -> OverlayWindow.removeFromFieldOverlay(window));
        });
        this.setVisible(false);
    }

    public void addAbility(Ability ability) {
        if (this.listAbilities.contains(ability)) {
            return;
        }
        this.listAbilities.add(ability);
        if (this.listAbilities.size() == 1) {
            this.setVisible(true);
        }
    }

    public void removeAbility(Ability ability) {
        if (this.listAbilities.remove(ability) && this.listAbilities.isEmpty()) {
            this.setVisible(false);
        }
    }

    @Override
    public void dispose() {
        this.setOnMouseClicked(null);
        this.listAbilities.clear();
    }
}

