/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.paint.Color;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.Zone;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.ZoneBarrierIndicator;
import open.batoru.game.gfx.GFXZoneWall;

public class FieldZoneBarrierIndicators
extends Group3D {
    private final Map<BarrierType, ZoneBarrierIndicator> mapIndicators = new HashMap<BarrierType, ZoneBarrierIndicator>();
    private final Map<BarrierType, GFXZoneWall> mapGFX = new EnumMap<BarrierType, GFXZoneWall>(BarrierType.class);
    private final boolean isFlipped = Zone.getShouldFlip();

    public void addIndicator(BarrierType barrierType) {
        if (!this.mapIndicators.containsKey((Object)barrierType)) {
            GFXZoneWall gfx = new GFXZoneWall(Zone.getZoneOwner(this.isFlipped), GameConst.CardLocation.LIFE_CLOTH, barrierType.getTexture());
            this.mapGFX.put(barrierType, gfx);
            gfx.attach();
            ZoneBarrierIndicator indicator = this.getZoneBarrierIndicator(barrierType);
            this.mapIndicators.put(barrierType, indicator);
            this.getChildren().add((Object)indicator);
        }
        this.mapIndicators.get((Object)barrierType).add();
    }

    private ZoneBarrierIndicator getZoneBarrierIndicator(BarrierType barrierType) {
        ZoneBarrierIndicator indicator = new ZoneBarrierIndicator(barrierType);
        if (this.isFlipped) {
            indicator.setRotateX(90.0);
            indicator.setRotateZ(180.0);
            if (barrierType == BarrierType.SIGNI) {
                indicator.setTransZ(-85.0);
            }
        } else if (barrierType == BarrierType.SIGNI) {
            indicator.setTransX(85.0);
        }
        return indicator;
    }

    public void removeIndicator(BarrierType barrierType) {
        if (this.mapIndicators.get((Object)barrierType) != null && this.mapIndicators.get((Object)barrierType).remove() == 0) {
            this.mapGFX.get((Object)barrierType).detach();
            this.mapGFX.remove((Object)barrierType);
            this.getChildren().remove((Object)this.mapIndicators.get((Object)barrierType));
            this.mapIndicators.remove((Object)barrierType);
        }
    }

    public static enum BarrierType {
        LRIG(Color.rgb((int)0, (int)128, (int)128), "LRIG"),
        SIGNI(Color.rgb((int)255, (int)85, (int)85), "SIGNI");

        private final Color color;
        private final String texture;

        private BarrierType(Color color, String texture) {
            this.color = color;
            this.texture = texture;
        }

        public Color getColor() {
            return this.color;
        }

        public String getTexture() {
            return this.texture;
        }
    }
}

