/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import open.batoru.ImageCache;
import open.batoru.core.Disposable;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardLoader;
import open.batoru.game._3d.Plane;
import open.batoru.ui.UI;

public class FieldZoneBond
extends Plane
implements Disposable {
    private static final Rectangle2D PORTRAIT_AREA = new Rectangle2D(33.0, 23.0, 200.0, 180.0);
    private static final Rectangle2D PORTRAIT_AREA_OFFSET_LEFT = new Rectangle2D(13.0, 23.0, 200.0, 180.0);
    private static final Rectangle2D PORTRAIT_AREA_OFFSET_RIGHT = new Rectangle2D(73.0, 23.0, 200.0, 180.0);
    private static final Rectangle2D PORTRAIT_AREA_OFFSET_CENTER_RIGHT = new Rectangle2D(73.0, 43.0, 200.0, 180.0);
    private final Plane portrait;
    private final Plane heart;

    public FieldZoneBond(String imageSet) {
        super(105, 128, ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("bonds/border")), Plane.TextureTrimMode.LOWER_EDGE);
        this.setTransZ(-80.0);
        this.setRotateX(60.0);
        this.portrait = new Plane(99, 95, this.getPortraitImage(imageSet));
        this.portrait.setTransY(-12.0);
        this.portrait.setTransZ(-2.0);
        this.portrait.setOnMouseEntered(e -> UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(imageSet));
        this.heart = new Plane(50, 45, ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("bonds/heart")), Plane.TextureTrimMode.LOWER_EDGE);
        this.heart.setTransX(45.0);
        this.heart.setTransY(-50.0);
        this.heart.setTransZ(-4.0);
        this.getChildren().addAll((Object[])new Node[]{this.portrait, this.heart});
        this.setScale(1.2);
        this.heart.setMouseTransparent(true);
    }

    private Image getPortraitImage(String imageSet) {
        ImageView cardImage = new ImageView(ImageCache.INSTANCE.getCardImage(imageSet));
        cardImage.setViewport(PORTRAIT_AREA);
        SnapshotParameters snapshotParams = new SnapshotParameters();
        if (CardLoader.getImageSetMaskType(imageSet) == CardDataImageSet.MaskType.PORTRAIT_OFFSET_LEFT) {
            snapshotParams.setViewport(PORTRAIT_AREA_OFFSET_LEFT);
        } else if (CardLoader.getImageSetMaskType(imageSet) == CardDataImageSet.MaskType.PORTRAIT_OFFSET_RIGHT) {
            snapshotParams.setViewport(PORTRAIT_AREA_OFFSET_RIGHT);
        } else if (CardLoader.getImageSetMaskType(imageSet) == CardDataImageSet.MaskType.PORTRAIT_OFFSET_CENTER_RIGHT) {
            snapshotParams.setViewport(PORTRAIT_AREA_OFFSET_CENTER_RIGHT);
        } else {
            snapshotParams.setViewport(PORTRAIT_AREA);
        }
        WritableImage writableImage = new WritableImage(99, 95);
        cardImage.snapshot(snapshotParams, writableImage);
        return writableImage;
    }

    @Override
    public void dispose() {
        this.portrait.setOnMouseEntered(null);
        this.portrait.getMaterial().setDiffuseMap(null);
        this.heart.getMaterial().setDiffuseMap(null);
    }
}

