/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.game._3d.Plane;
import open.batoru.game._3d.textures.UtilTexture;

public class FieldZoneCrossIndicator
extends Plane {
    private static final String TEXTURE_ACTIVE = "/textures/zones/cross/heaven_half.png";
    private static final String TEXTURE_OUTLINE_DISABLED = "textures/zones/cross/outline_disabled.png";
    private static final String TEXTURE_OUTLINE_HEAVEN = "textures/zones/cross/outline_heaven.png";
    private final CrossPosition position;
    private CrossState state;
    private static Image cacheTextureInactive;

    public FieldZoneCrossIndicator(CrossPosition position) {
        super(60, 113, FieldZoneCrossIndicator.getTextureInactive());
        if (position == CrossPosition.RIGHT) {
            this.getMesh().getTexCoords().setAll(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f});
        }
        this.position = position;
        this.setState(CrossState.INACTIVE);
        this.setMouseTransparent(true);
    }

    private static Image getTextureInactive() {
        if (cacheTextureInactive == null) {
            cacheTextureInactive = UtilTexture.grayscale(ImageCache.INSTANCE.getImage(TEXTURE_ACTIVE));
        }
        return cacheTextureInactive;
    }

    public final void setState(CrossState state) {
        if (state == null || state == this.state) {
            return;
        }
        this.state = state;
        switch (state.ordinal()) {
            case 0: {
                this.getMaterial().setDiffuseColor(Color.DIMGREY);
                this.getMaterial().setDiffuseMap(FieldZoneCrossIndicator.getTextureInactive());
                this.getMaterial().setSelfIlluminationMap(ImageCache.INSTANCE.getImage(TEXTURE_OUTLINE_DISABLED));
                break;
            }
            case 2: {
                this.getMaterial().setDiffuseColor(Color.rgb((int)128, (int)128, (int)128));
                this.getMaterial().setDiffuseMap(ImageCache.INSTANCE.getImage(TEXTURE_ACTIVE));
                this.getMaterial().setSelfIlluminationMap(null);
                break;
            }
            case 1: {
                this.getMaterial().setDiffuseColor(Color.rgb((int)128, (int)128, (int)128));
                this.getMaterial().setDiffuseMap(FieldZoneCrossIndicator.getTextureInactive());
                this.getMaterial().setSelfIlluminationMap(null);
                break;
            }
            case 3: {
                this.getMaterial().setDiffuseColor(Color.rgb((int)240, (int)240, (int)240));
                this.getMaterial().setDiffuseMap(ImageCache.INSTANCE.getImage(TEXTURE_ACTIVE));
                this.getMaterial().setSelfIlluminationMap(null);
                break;
            }
            case 4: {
                this.getMaterial().setDiffuseColor(Color.WHITE);
                this.getMaterial().setDiffuseMap(ImageCache.INSTANCE.getImage(TEXTURE_ACTIVE));
                this.getMaterial().setSelfIlluminationMap(ImageCache.INSTANCE.getImage(TEXTURE_OUTLINE_HEAVEN));
            }
        }
    }

    public CrossPosition getPosition() {
        return this.position;
    }

    public CrossState getState() {
        return this.state;
    }

    public void updateState(int newValue) {
        boolean isDowned;
        boolean isCrossed = (newValue & (this.position == CrossPosition.LEFT ? 131072 : 262144)) != 0;
        boolean bl = isDowned = (newValue & 0x4000) != 0;
        if (!isCrossed) {
            this.setState(CrossState.INACTIVE);
        } else if (this.getState() != CrossState.HEAVEN || !isDowned) {
            this.setState(isDowned ? CrossState.DOWNED : CrossState.ACTIVE);
        }
    }

    public static enum CrossPosition {
        LEFT,
        RIGHT;

    }

    public static enum CrossState {
        DISABLED,
        INACTIVE,
        ACTIVE,
        DOWNED,
        HEAVEN;

    }
}

