/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.stock.StockAbilityCross;
import open.batoru.game.FieldData;
import open.batoru.game.FieldZone;
import open.batoru.game.FieldZoneCrossIndicator;
import open.batoru.game.ZoneSIGNI;

public class FieldZoneCrossIndicatorGuides {
    private Set<ZoneSIGNI> tempGuideEmptyZones;
    private Map<FieldZoneCrossIndicator, FieldZoneCrossIndicator.CrossState> tempPreviewChangedIndicators;

    public void apply(CardIndex cardIndex, ZoneSIGNI zoneSIGNI) {
        FieldZoneCrossIndicator.CrossPosition[] crossPositionArray;
        if (cardIndex.getIndexedInstance().getAbilityList().isEmpty() || !((crossPositionArray = cardIndex.getIndexedInstance().getAbilityList().getFirst().getSourceStockAbility()) instanceof StockAbilityCross)) {
            return;
        }
        StockAbilityCross stockAbilityCross = (StockAbilityCross)crossPositionArray;
        block0: for (FieldZoneCrossIndicator.CrossPosition position : FieldZoneCrossIndicator.CrossPosition.values()) {
            String[] crossNames;
            String[] stringArray = position == FieldZoneCrossIndicator.CrossPosition.LEFT ? (stockAbilityCross.getRightOf() != null ? stockAbilityCross.getRightOf().names() : null) : (crossNames = stockAbilityCross.getLeftOf() != null ? stockAbilityCross.getLeftOf().names() : null);
            if (crossNames == null) continue;
            FieldZoneCrossIndicator crossIndicator = zoneSIGNI.installZoneCrossIndicator(position);
            if (this.tempGuideEmptyZones == null) {
                this.tempGuideEmptyZones = new HashSet<ZoneSIGNI>();
            }
            this.tempGuideEmptyZones.add(zoneSIGNI);
            GameConst.SIGNIZonePosition zonePosition = GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(zoneSIGNI.getZoneLocation());
            if (position == FieldZoneCrossIndicator.CrossPosition.LEFT && zonePosition != GameConst.SIGNIZonePosition.LEFT || position == FieldZoneCrossIndicator.CrossPosition.RIGHT && zonePosition != GameConst.SIGNIZonePosition.RIGHT) {
                ZoneSIGNI zoneSIGNIOther = (ZoneSIGNI)FieldData.getZoneByLocation(Game.getCurrentGame().getPlayerRole(), position == FieldZoneCrossIndicator.CrossPosition.LEFT ? GameConst.CardLocation.getLeftSIGNILocation(zoneSIGNI.getZoneLocation()) : GameConst.CardLocation.getRightSIGNILocation(zoneSIGNI.getZoneLocation()));
                if (zoneSIGNIOther == null || !FieldZone.isOccupied(zoneSIGNIOther)) continue;
                for (String name : crossNames) {
                    if (!zoneSIGNIOther.getTopCard().getCardIndex().getCardReference().getOriginalName().equals(name)) continue;
                    crossIndicator.setState(FieldZoneCrossIndicator.CrossState.ACTIVE);
                    FieldZoneCrossIndicator crossIndicatorOther = zoneSIGNIOther.installZoneCrossIndicator(position == FieldZoneCrossIndicator.CrossPosition.LEFT ? FieldZoneCrossIndicator.CrossPosition.RIGHT : FieldZoneCrossIndicator.CrossPosition.LEFT);
                    if (this.tempPreviewChangedIndicators == null) {
                        this.tempPreviewChangedIndicators = new HashMap<FieldZoneCrossIndicator, FieldZoneCrossIndicator.CrossState>();
                    }
                    this.tempPreviewChangedIndicators.put(crossIndicatorOther, crossIndicatorOther.getState());
                    crossIndicatorOther.setState(FieldZoneCrossIndicator.CrossState.ACTIVE);
                    continue block0;
                }
                continue;
            }
            crossIndicator.setState(FieldZoneCrossIndicator.CrossState.DISABLED);
        }
    }

    public void clear() {
        if (this.tempGuideEmptyZones != null) {
            this.tempGuideEmptyZones.forEach(ZoneSIGNI::uninstallAllZoneCrossIndicators);
        }
        if (this.tempPreviewChangedIndicators != null) {
            this.tempPreviewChangedIndicators.forEach(FieldZoneCrossIndicator::setState);
        }
    }
}

