/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import java.util.List;
import open.batoru.core.Game;
import open.batoru.data.CardConst;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.EnerColor;
import open.batoru.game._3d.Group3D;
import open.batoru.game.animations.AnimationEnerColorSelect;
import open.batoru.ui.UI;

public class FieldZoneEnerGroup
extends Group3D {
    private final double enerColorSize;
    private final Card3D card3D;
    private final List<EnerColor> listEnerColors = new ArrayList<EnerColor>();
    private EnerColor selectedEnerColor;
    private AnimationEnerColorSelect aniSelect;

    public FieldZoneEnerGroup(Card3D card3D) {
        this.card3D = card3D;
        this.enerColorSize = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(Card3D.getCurrentOwner(card3D)).getEnerZone().calculateSpacing(1, 0) * 0.83;
        this.setTransX(125.0 - this.enerColorSize / 2.0);
        this.setTransY(-174.5);
    }

    public void addEnerColor(CardConst.CardColor color) {
        EnerColor enerColor = new EnerColor(this, color, this.listEnerColors.size() + 1);
        this.listEnerColors.add(enerColor);
        this.getChildren().add((Object)enerColor);
    }

    public void toggleSelect(EnerColor enerColor) {
        this.selectedEnerColor = enerColor != this.selectedEnerColor ? enerColor : null;
        this.playSelectionAnimation(this.card3D, enerColor, enerColor == this.selectedEnerColor);
    }

    private void playSelectionAnimation(Card3D card3D, EnerColor enerColor, boolean forward) {
        if (Game.getCurrentGame().getFakeReceiver() != null) {
            return;
        }
        if (this.aniSelect != null) {
            this.aniSelect.stop();
        }
        this.aniSelect = new AnimationEnerColorSelect(card3D, enerColor, forward);
        this.aniSelect.play();
    }

    public EnerColor getSelectedEnerColor() {
        return this.selectedEnerColor;
    }

    public Card3D getSourceCard3D() {
        return this.card3D;
    }

    public List<EnerColor> getEnerColorsList() {
        return this.listEnerColors;
    }

    public double getEnerColorSize() {
        return this.enerColorSize;
    }
}

