/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.scene.Node;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.ZoneUnderTypeIndicator;

public class FieldZoneUnderCardsIndicators
extends Group3D {
    private final Map<GameConst.CardUnderType, ZoneUnderTypeIndicator> mapIndicators = new HashMap<GameConst.CardUnderType, ZoneUnderTypeIndicator>();

    public void clearAllCardIndicators() {
        Iterator<GameConst.CardUnderType> iterator = this.mapIndicators.keySet().iterator();
        while (iterator.hasNext()) {
            GameConst.CardUnderType underType = iterator.next();
            if (underType.getUnderCategory() == GameConst.CardUnderCategory.ZONE) continue;
            this.getChildren().remove((Object)this.mapIndicators.get((Object)underType));
            iterator.remove();
        }
    }

    public void clearAll() {
        this.getChildren().clear();
        this.mapIndicators.clear();
    }

    public void addUnderType(GameConst.CardUnderType underType) {
        if (underType != GameConst.CardUnderType.NONE) {
            if (!this.mapIndicators.containsKey((Object)underType)) {
                this.mapIndicators.put(underType, new ZoneUnderTypeIndicator(underType));
                this.getChildren().add((Object)((Node)this.mapIndicators.get((Object)underType)));
            }
            this.mapIndicators.get((Object)underType).add();
        }
    }

    public void removeUnderType(GameConst.CardUnderType underType) {
        if (underType != GameConst.CardUnderType.NONE && this.mapIndicators.get((Object)underType) != null && this.mapIndicators.get((Object)underType).remove() == 0) {
            this.getChildren().remove((Object)this.mapIndicators.get((Object)underType));
            this.mapIndicators.remove((Object)underType);
        }
    }

    public boolean hasUnderType(GameConst.CardUnderType underType) {
        return this.mapIndicators.containsKey((Object)underType);
    }
}

