/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.Arrays;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import open.batoru.core.Deck;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.CardConst;
import open.batoru.game.FieldBackground;
import open.batoru.game.FieldData;
import open.batoru.game.FieldVisualStateCoordinator;
import open.batoru.game.FieldZone;
import open.batoru.game.FieldZoneBond;
import open.batoru.game.FieldZoneHighlighter;
import open.batoru.game.FieldZoneSpinner;
import open.batoru.game.PlayerHand;
import open.batoru.game.Zone;
import open.batoru.game.ZoneCheck;
import open.batoru.game.ZoneCheer;
import open.batoru.game.ZoneDeck;
import open.batoru.game.ZoneEner;
import open.batoru.game.ZoneKey;
import open.batoru.game.ZoneLRIG;
import open.batoru.game.ZoneLRIGAssist;
import open.batoru.game.ZoneLifeCloth;
import open.batoru.game.ZoneLook;
import open.batoru.game.ZoneReveal;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Group3D;
import open.batoru.ui.UI;
import open.batoru.ui.UtilDispose;

public class PlayerField
extends Group3D
implements Disposable {
    private FieldZoneHighlighter highlighter;
    private FieldVisualStateCoordinator coordinator;
    private final FieldBackground background;
    private double centerOffset;
    private final Group3D bonds = new Group3D();
    private ZoneCheer cheerZone;
    private ZoneSIGNI[] SIGNI = new ZoneSIGNI[3];
    private ZoneDeck deckMain;
    private ZoneDeck trash;
    private ZoneCheck checkZone;
    private ZoneLRIGAssist LRIGZoneAssistLeft;
    private ZoneLRIG LRIGZone;
    private ZoneLRIGAssist LRIGZoneAssistRight;
    private ZoneKey zoneKeyLRIG;
    private ZoneKey zoneKey;
    private ZoneDeck deckLRIG;
    private ZoneDeck trashLRIG;
    private ZoneEner enerZone;
    private ZoneLifeCloth lifeCloth;
    private ZoneReveal revealZone;
    private ZoneLook lookZone;
    private PlayerHand hand;
    private final FieldData data = new FieldData();

    public PlayerField(boolean shouldFlip) {
        FieldZone.setShouldFlip(shouldFlip);
        this.background = new FieldBackground(this.getColumn(1.1) - 15.0, this.getRow(1.0));
        this.cheerZone = new ZoneCheer(0.0, 0.0);
        this.SIGNI[GameConst.SIGNIZonePosition.LEFT.getId()] = new ZoneSIGNI(0.0, 20.0, GameConst.CardLocation.SIGNI_LEFT);
        this.SIGNI[GameConst.SIGNIZonePosition.CENTER.getId()] = new ZoneSIGNI(this.getColumn(1.0), 20.0, GameConst.CardLocation.SIGNI_CENTER);
        this.SIGNI[GameConst.SIGNIZonePosition.RIGHT.getId()] = new ZoneSIGNI(this.getColumn(2.0), 20.0, GameConst.CardLocation.SIGNI_RIGHT);
        this.deckMain = new ZoneDeck(Deck.DeckType.MAIN, false, this.getColumn(3.0), 0.0);
        this.trash = new ZoneDeck(Deck.DeckType.MAIN, true, this.getColumn(4.0), 0.0);
        this.revealZone = new ZoneReveal(this.getColumn(1.0), 0.0, -250.0);
        this.lookZone = new ZoneLook(this.getColumn(1.0), this.getRow(1.0), -250.0);
        this.hand = new PlayerHand(this.getColumn(1.0), this.getRow(shouldFlip ? 2.5 : 2.0));
        FieldZoneSpinner spinnerLRIGCoins = new FieldZoneSpinner(this.getColumn(1.3), this.getRow(1.0));
        this.checkZone = new ZoneCheck(this.getColumn(-0.35), this.getRow(1.0));
        this.LRIGZoneAssistLeft = new ZoneLRIGAssist(this.getColumn(0.5) + 6.0, this.getRow(1.0), GameConst.CardLocation.LRIG_ASSIST_LEFT);
        this.LRIGZone = new ZoneLRIG(this.getColumn(1.3), this.getRow(1.0), this.background, spinnerLRIGCoins);
        this.LRIGZoneAssistRight = new ZoneLRIGAssist(this.getColumn(2.1) - 6.0, this.getRow(1.0), GameConst.CardLocation.LRIG_ASSIST_RIGHT);
        this.deckLRIG = new ZoneDeck(Deck.DeckType.LRIG, false, this.getColumn(3.0), this.getRow(1.0));
        this.trashLRIG = new ZoneDeck(Deck.DeckType.LRIG, true, this.getColumn(4.0), this.getRow(1.0));
        this.enerZone = new ZoneEner(this.getColumn(-1.25), this.getRow(0.5) - 10.0);
        this.lifeCloth = new ZoneLifeCloth(this.getColumn(1.0), this.getRow(1.75));
        this.zoneKeyLRIG = new ZoneKey(this.getColumn(1.8) + 20.0, this.getRow(1.0), true);
        this.zoneKey = new ZoneKey(this.getColumn(2.7), this.getRow(1.75), false);
        CardConst.PlayFormat playFormat = Game.getCurrentGame().getRoom().getPlayFormat();
        if (playFormat == CardConst.PlayFormat.ALLSTAR || playFormat == CardConst.PlayFormat.KEY) {
            this.zoneKey.getNode().setVisible(true);
        }
        this.getChildren().addAll((Object[])new Node[]{this.background, spinnerLRIGCoins, this.SIGNI[GameConst.SIGNIZonePosition.LEFT.getId()].getNode(), this.SIGNI[GameConst.SIGNIZonePosition.CENTER.getId()].getNode(), this.SIGNI[GameConst.SIGNIZonePosition.RIGHT.getId()].getNode(), this.deckMain.getNode(), this.trash.getNode(), this.checkZone.getNode(), this.LRIGZoneAssistLeft.getNode(), this.LRIGZone.getNode(), this.LRIGZoneAssistRight.getNode(), this.deckLRIG.getNode(), this.trashLRIG.getNode(), this.enerZone.getNode(), this.lifeCloth.getNode(), this.zoneKeyLRIG.getNode(), this.zoneKey.getNode(), this.revealZone.getNode(), this.lookZone.getNode(), this.hand.getNode()});
        if (shouldFlip) {
            this.setRotateZ(180.0);
            this.setTransX(400.0 + this.getColumn(2.0));
            this.setTransY(700.0);
        } else {
            this.setTransX(400.0);
            this.setTransY(1200.0);
        }
    }

    public void collapseLRIGAssistZones() {
        if (!this.LRIGZoneAssistLeft.getNode().isVisible()) {
            return;
        }
        boolean isFlipped = this.LRIGZone.isFlipped();
        this.LRIGZoneAssistLeft.getNode().setVisible(false);
        this.LRIGZoneAssistRight.getNode().setVisible(false);
        this.centerOffset = this.LRIGZone.getNode().getTransX() - this.SIGNI[GameConst.SIGNIZonePosition.CENTER.getId()].getNode().getTransX();
        this.enerZone.getNode().setTransX(this.enerZone.getNode().getTransX() + this.getColumn(0.2));
        this.checkZone.getNode().setTransX(this.SIGNI[GameConst.SIGNIZonePosition.LEFT.getId()].getNode().getTransX());
        this.LRIGZone.getNode().setTransX(this.SIGNI[GameConst.SIGNIZonePosition.CENTER.getId()].getNode().getTransX());
        this.LRIGZone.getSpinnerCoins().setTransX(this.LRIGZone.getNode().getTransX());
        this.LRIGZone.getZoneAttachedAbilitiesIndicator().setTransX(this.LRIGZone.getZoneAttachedAbilitiesIndicator().getTransX() - this.centerOffset);
        CardConst.PlayFormat playFormat = Game.getCurrentGame().getRoom().getPlayFormat();
        if (playFormat == CardConst.PlayFormat.DIVA) {
            this.trashLRIG.getNode().setTransX(this.SIGNI[GameConst.SIGNIZonePosition.RIGHT.getId()].getNode().getTransX());
        } else {
            this.zoneKeyLRIG.getNode().setVisible(true);
            if (playFormat == CardConst.PlayFormat.ALLSTAR || playFormat == CardConst.PlayFormat.KEY) {
                this.zoneKey.getNode().setVisible(false);
            }
        }
        if (isFlipped) {
            this.bonds.setTransX(this.bonds.getTransX() - 36.0);
        } else {
            this.bonds.setTransX(this.bonds.getTransX() + 36.0);
            this.lifeCloth.getZoneBarrierIndicators().setTransX(this.lifeCloth.getZoneBarrierIndicators().getTransX() + this.getColumn(0.14));
        }
        Game.getCurrentGame().getRoom().getPlayerData(Zone.getZoneOwner(this.LRIGZone)).getLRIGAssistLeftImageProperty().set((Object)"");
        Game.getCurrentGame().getRoom().getPlayerData(Zone.getZoneOwner(this.LRIGZone)).getLRIGAssistRightImageProperty().set((Object)"");
    }

    public void addBondAvatar(String imageSet) {
        FieldZoneBond fieldBond = new FieldZoneBond(imageSet);
        fieldBond.setTransY(this.bonds.getChildren().size() * (this.checkZone.isFlipped() ? 1 : -1) * 90);
        if (this.checkZone.isFlipped()) {
            this.bonds.getChildren().add((Object)fieldBond);
        } else {
            this.bonds.getChildren().addFirst((Object)fieldBond);
        }
    }

    public void installExtraNodes() {
        Point2D scenePos = this.checkZone.getNode().localToScene(0.0, 0.0);
        if (this.checkZone.isFlipped()) {
            this.bonds.setTransX(scenePos.getX() + 90.0);
            this.bonds.setTransY(scenePos.getY() + 280.0);
        } else {
            this.bonds.setTransX(scenePos.getX() - 90.0);
            this.bonds.setTransY(scenePos.getY() - 300.0);
        }
        UI.getTabGame().getFieldScene().getGameField().getChildren().add((Object)this.bonds);
        this.SIGNI[GameConst.SIGNIZonePosition.LEFT.getId()].installZoneNumbers(this);
        this.SIGNI[GameConst.SIGNIZonePosition.CENTER.getId()].installZoneNumbers(this);
        this.SIGNI[GameConst.SIGNIZonePosition.RIGHT.getId()].installZoneNumbers(this);
        this.LRIGZone.installZoneAttachedAbilitiesIndicator(this);
    }

    public ZoneDeck getDeckZone(Deck.DeckType deckType) {
        return deckType == Deck.DeckType.MAIN ? this.deckMain : this.deckLRIG;
    }

    public ZoneDeck getTrashZone(Deck.DeckType deckType) {
        return deckType == Deck.DeckType.MAIN ? this.trash : this.trashLRIG;
    }

    public ZoneSIGNI getSIGNIZone(GameConst.SIGNIZonePosition zonePosition) {
        return this.SIGNI[zonePosition.getId()];
    }

    public ZoneCheer getCheerZone() {
        return this.cheerZone;
    }

    public ZoneLRIG getLRIGZone() {
        return this.LRIGZone;
    }

    public ZoneLRIGAssist getLRIGAssistZoneLeft() {
        return this.LRIGZoneAssistLeft;
    }

    public ZoneLRIGAssist getLRIGAssistZoneRight() {
        return this.LRIGZoneAssistRight;
    }

    public ZoneKey getKeyZone() {
        return this.zoneKeyLRIG.getNode().isVisible() ? this.zoneKeyLRIG : this.zoneKey;
    }

    public ZoneCheck getCheckZone() {
        return this.checkZone;
    }

    public ZoneEner getEnerZone() {
        return this.enerZone;
    }

    public ZoneLifeCloth getLifeClothZone() {
        return this.lifeCloth;
    }

    public ZoneReveal getRevealZone() {
        return this.revealZone;
    }

    public ZoneLook getLookZone() {
        return this.lookZone;
    }

    public PlayerHand getHand() {
        return this.hand;
    }

    public void setZoneColor(Color color) {
        if (this.deckMain == null) {
            return;
        }
        this.deckMain.setDefaultColor(color);
        this.deckLRIG.setDefaultColor(color);
        this.trash.setDefaultColor(color);
        this.trashLRIG.setDefaultColor(color);
        this.SIGNI[GameConst.SIGNIZonePosition.LEFT.getId()].setDefaultColor(color);
        this.SIGNI[GameConst.SIGNIZonePosition.CENTER.getId()].setDefaultColor(color);
        this.SIGNI[GameConst.SIGNIZonePosition.RIGHT.getId()].setDefaultColor(color);
        this.cheerZone.setDefaultColor(color);
        this.LRIGZone.setDefaultColor(color);
        this.LRIGZoneAssistLeft.setDefaultColor(color);
        this.LRIGZoneAssistRight.setDefaultColor(color);
        this.zoneKeyLRIG.setDefaultColor(color);
        this.zoneKey.setDefaultColor(color);
        this.checkZone.setDefaultColor(color);
        this.enerZone.setDefaultColor(color);
        this.lifeCloth.setDefaultColor(color);
    }

    public void initZoneHighlighter() {
        if (this.highlighter != null) {
            return;
        }
        this.highlighter = new FieldZoneHighlighter(this);
        this.getChildren().add((Object)this.highlighter);
    }

    public FieldZoneHighlighter getZoneHighlighter() {
        return this.highlighter;
    }

    public void initVisualStateCoordinator() {
        if (this.coordinator != null) {
            return;
        }
        this.coordinator = new FieldVisualStateCoordinator(this);
    }

    public FieldVisualStateCoordinator getVisualStateCoordinator() {
        return this.coordinator;
    }

    public FieldBackground getFieldBackground() {
        return this.background;
    }

    public FieldData getData() {
        return this.data;
    }

    private double getRow(double row) {
        return row * 509.0;
    }

    private double getColumn(double column) {
        return column * 439.0;
    }

    public double getCenterOffset() {
        return this.centerOffset;
    }

    public int getSIGNILimitSum() {
        return Arrays.stream(this.SIGNI).filter(FieldZone::isOccupied).mapToInt(zoneSIGNI -> (int)zoneSIGNI.getTopCard().getCardIndex().getSIGNILimitConsumption()).sum();
    }

    public int getSIGNICount(boolean includeCheer) {
        return (int)Arrays.stream(this.SIGNI).filter(FieldZone::isOccupied).count() + (includeCheer && FieldZone.isOccupied(this.cheerZone) ? 1 : 0);
    }

    @Override
    public void dispose() {
        this.deckMain.dispose();
        this.deckLRIG.dispose();
        this.trash.dispose();
        this.trashLRIG.dispose();
        this.SIGNI[GameConst.SIGNIZonePosition.LEFT.getId()].dispose();
        this.SIGNI[GameConst.SIGNIZonePosition.CENTER.getId()].dispose();
        this.SIGNI[GameConst.SIGNIZonePosition.RIGHT.getId()].dispose();
        this.cheerZone.dispose();
        this.LRIGZone.dispose();
        this.LRIGZoneAssistLeft.dispose();
        this.LRIGZoneAssistRight.dispose();
        this.zoneKeyLRIG.dispose();
        this.zoneKey.dispose();
        this.checkZone.dispose();
        this.enerZone.dispose();
        this.lifeCloth.dispose();
        this.revealZone.dispose();
        this.lookZone.dispose();
        this.hand.dispose();
        this.deckMain = null;
        this.deckLRIG = null;
        this.trash = null;
        this.trashLRIG = null;
        Arrays.fill(this.SIGNI, null);
        this.SIGNI = null;
        this.cheerZone = null;
        this.LRIGZone = null;
        this.LRIGZoneAssistLeft = null;
        this.LRIGZoneAssistRight = null;
        this.zoneKeyLRIG = null;
        this.zoneKey = null;
        this.checkZone = null;
        this.enerZone = null;
        this.lifeCloth = null;
        this.revealZone = null;
        this.lookZone = null;
        this.hand = null;
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.bonds);
        this.bonds.getChildren().clear();
        this.getChildren().clear();
        this.highlighter = null;
        this.coordinator = null;
    }
}

