/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;
import open.batoru.game.animations.AnimationHandHover;
import open.batoru.ui.UI;

public class PlayerHand
extends Zone {
    private final Vector3D CARD_ROTATION = new Vector3D(30.0, 0.0, 0.0);
    private final Vector3D CARD_ROTATION_NEUTRAL = new Vector3D(60.0, 0.0, 180.0);
    private final Map<Card3D, Card3DHoverAnimation> mapHoverAnimations = new HashMap<Card3D, Card3DHoverAnimation>();

    public PlayerHand(double x, double y) {
        super(0, 349);
        this.getNode().setTranslate(x, y, -160.0);
        this.getNode().setRotateX(30.0);
        if (this.isFlipped()) {
            this.CARD_ROTATION.setX(90.0);
        }
    }

    private double calculateCardOffset(int i) {
        int sign;
        int num = this.getTotalCards();
        if (num == 0) {
            return 0.0;
        }
        int mid = num / 2;
        int n = sign = i < mid ? -1 : 1;
        if (num % 2 == 0) {
            if (i == mid) {
                return 0.0;
            }
            return (250 + 250 * (mid - 1)) * sign;
        }
        return (250.0f * ((float)(num - 1) / 2.0f) + 125.0f) * (float)sign;
    }

    @Override
    protected Vector3D getCardOriginOffset(int i) {
        return new Vector3D(this.calculateCardOffset(i), 0.0, 0.0);
    }

    @Override
    protected Vector3D getCardRotation(int i) {
        return !Game.getCurrentGame().isNeutralPerspectiveGame() || !this.isFlipped() ? this.CARD_ROTATION : this.CARD_ROTATION_NEUTRAL;
    }

    @Override
    public void prepareRearrangeAnimation(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType, Zone.ZonePosition addPosition) {
        if (this.getLastModifiedIndex() == -1 || this.getZoneCardList().isEmpty()) {
            return;
        }
        ArrayList<Zone.RearrangeAnimationData> listData = new ArrayList<Zone.RearrangeAnimationData>();
        for (int i = 0; i < this.getTotalCards(); ++i) {
            Card3D card3D = this.getZoneCardList().get(i);
            double start = card3D.getTransX();
            double end = 125.0;
            if (rearrangeType == Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_REMOVED && i < this.getLastModifiedIndex()) {
                end *= -1.0;
            }
            listData.add(new Zone.RearrangeAnimationData(card3D, start, end));
        }
        this.setOnRearrangeAnimationInterpolate(frac -> {
            for (Zone.RearrangeAnimationData data : listData) {
                data.card3D().setTransX(data.start() - data.diff() * frac);
            }
        });
    }

    @Override
    public void addCardToZoneList(Card3D card3D, Zone.ZonePosition addPosition) {
        super.addCardToZoneList(card3D, addPosition);
        this.installHandHover(card3D);
        if (card3D.getCardIndex().getIndexedInstance() != null && CardIndex.isOwnCard(card3D.getCardIndex())) {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(card3D.getCardIndex());
        }
    }

    @Override
    public void removeCardFromZoneList(Card3D card3D) {
        card3D.removeShatter();
        card3D.removeGlow();
        super.removeCardFromZoneList(card3D);
        this.uninstallHandHover(card3D);
    }

    @Override
    public Card3D getPrivateCard(String imageSet, int cardId, Zone.ZonePosition zonePosition) {
        return this.getRandomPrivateCard(imageSet, cardId);
    }

    public void installHandHover(Card3D card3D) {
        this.mapHoverAnimations.put(card3D, new Card3DHoverAnimation(this, card3D));
    }

    public void uninstallHandHover(Card3D card3D) {
        AnimationHandHover aniHover = this.getHandHoverAnimation(card3D).getAnimation();
        if (aniHover != null) {
            aniHover.stop();
        }
        this.mapHoverAnimations.remove(card3D);
        card3D.installMouseEvents();
    }

    public Card3DHoverAnimation getHandHoverAnimation(Card3D card3D) {
        return this.mapHoverAnimations.get(card3D);
    }

    public boolean isCardInHand(Card3D card3D) {
        return this.getZoneCardList().contains(card3D);
    }

    @Override
    public int getWidth() {
        switch (this.getTotalCards()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 250;
            }
        }
        Card3D nodeFirst = this.getBottomCard();
        Card3D nodeLast = this.getTopCard();
        return (int)(nodeLast.localToScene(nodeLast.getBoundsInLocal()).getMaxX() - nodeFirst.localToScene(nodeLast.getBoundsInLocal()).getMinX());
    }

    @Override
    public GameConst.CardLocation getZoneLocation() {
        return GameConst.CardLocation.HAND;
    }

    @Override
    public void dispose() {
        this.mapHoverAnimations.values().forEach(Card3DHoverAnimation::dispose);
        this.mapHoverAnimations.clear();
        super.dispose();
    }

    public static class Card3DHoverAnimation
    implements Disposable {
        private PlayerHand hand;
        private Card3D card3D;
        private AnimationHandHover aniHover;
        private boolean wasLastAniForward;
        private boolean isLocked;

        public Card3DHoverAnimation(PlayerHand hand, Card3D card3D) {
            this.hand = hand;
            this.card3D = card3D;
            card3D.setOnMouseEntered(e -> {
                if (card3D.getCardIndex().getIndexedInstance() != null && !e.isAltDown()) {
                    UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(card3D.getCardIndex());
                }
                this.playHoverAnimation(true);
            });
            card3D.setOnMouseExited(e -> this.playHoverAnimation(false));
        }

        private void playHoverAnimation(boolean forward) {
            if (this.isLocked) {
                return;
            }
            this.wasLastAniForward = forward;
            if (this.aniHover != null) {
                this.aniHover.stop();
            }
            this.aniHover = new AnimationHandHover(this.hand.getNode(), this.card3D, forward);
            this.aniHover.play();
        }

        public AnimationHandHover getAnimation() {
            return this.aniHover;
        }

        public void setLock(boolean lock) {
            this.isLocked = lock;
            if (!lock && this.wasLastAniForward && !this.card3D.hoverProperty().get()) {
                this.playHoverAnimation(false);
            }
        }

        public boolean isLocked() {
            return this.isLocked;
        }

        @Override
        public void dispose() {
            this.card3D.setOnMouseEntered(null);
            this.card3D.setOnMouseExited(null);
            this.hand = null;
            this.card3D = null;
            if (this.aniHover != null) {
                this.aniHover.stop();
            }
            this.aniHover = null;
        }
    }
}

