/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javafx.geometry.Point2D;
import open.batoru.Log;
import open.batoru.UtilRandom;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Vector3D;

public abstract class Zone
implements Disposable {
    private final int width;
    private final int height;
    private static boolean shouldFlip;
    private final boolean isFlipped;
    private List<Card3D> listCards = new ArrayList<Card3D>();
    private List<OnCardMovedHandler> listHandlersCardMoved;
    private OnRearrangeAnimationInterpolateHandler handlerAni;
    private int lastModifiedIndex = -1;
    private ArrayList<Card3D> cacheRandomizedCards;
    private boolean shouldUpdateRandomizedCache;
    private ArrayList<Card3D> cacheChosenCards;
    private int currentCachePos;
    private final Group3D node = new Group3D();

    public Zone(int width, int height) {
        this.isFlipped = shouldFlip;
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void prepareRearrangeAnimation(OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType, ZonePosition addPosition) {
    }

    public void interpolateRearrangeAnimation(double frac) {
        if (this.handlerAni != null) {
            this.handlerAni.interpolate(frac);
        }
    }

    public void setOnRearrangeAnimationInterpolate(OnRearrangeAnimationInterpolateHandler handler) {
        this.handlerAni = handler;
    }

    public void addCardToZoneList(Card3D card3D, ZonePosition addPosition) {
        card3D.setOwnerZone(this);
        if (addPosition == ZonePosition.TOP) {
            this.listCards.add(card3D);
        } else {
            int pos;
            for (pos = 0; !this.listCards.isEmpty() && pos < this.listCards.size() && this.listCards.get(pos).getCardIndex().getUnderType().getUnderCategory() == GameConst.CardUnderCategory.ZONE; ++pos) {
            }
            this.listCards.add(pos, card3D);
        }
        this.lastModifiedIndex = this.listCards.indexOf(card3D);
        this.shouldUpdateRandomizedCache = true;
        this.updateZone(OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED);
        card3D.setShouldClearImageSet(card3D.getCardIndex().getIndexedInstance() != null && !GameConst.CardLocation.isPublic(this.getZoneLocation()) && (!GameConst.CardLocation.isPlayerPrivate(this.getZoneLocation()) || !CardIndex.isOwnCard(card3D.getCardIndex())));
        if (this.listHandlersCardMoved != null) {
            for (OnCardMovedHandler handler : this.listHandlersCardMoved) {
                handler.handle(card3D, OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED);
            }
        }
    }

    public void prepareNextModifiedIndex(int lastModifiedIndex) {
        this.lastModifiedIndex = lastModifiedIndex;
    }

    public void removeCardFromZoneList(Card3D card3D) {
        this.lastModifiedIndex = this.listCards.indexOf(card3D);
        this.listCards.remove(card3D);
        if (this.cacheChosenCards != null) {
            this.cacheChosenCards.remove(card3D);
        }
        if (this.cacheRandomizedCards != null) {
            this.cacheRandomizedCards.remove(card3D);
        }
        this.currentCachePos = 0;
        this.updateZone(OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_REMOVED);
        if (this.listHandlersCardMoved != null) {
            for (OnCardMovedHandler handler : this.listHandlersCardMoved) {
                handler.handle(card3D, OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_REMOVED);
            }
        }
    }

    public final void setOnCardMoved(OnCardMovedHandler handler) {
        if (this.listHandlersCardMoved == null) {
            this.listHandlersCardMoved = new ArrayList<OnCardMovedHandler>();
        }
        this.listHandlersCardMoved.add(handler);
    }

    public final void removeCardMovedHandler(OnCardMovedHandler handler) {
        if (this.listHandlersCardMoved != null && this.listHandlersCardMoved.remove(handler) && this.listHandlersCardMoved.isEmpty()) {
            this.listHandlersCardMoved = null;
        }
    }

    public final Card3D getTopCard() {
        return this.getTopCard(0);
    }

    public final Card3D getTopCard(int offset) {
        int arrayId = this.getTotalCards() - 1 - offset;
        return arrayId >= 0 ? this.getZoneCardList().get(arrayId) : null;
    }

    public final Card3D getBottomCard() {
        return this.getBottomCard(0);
    }

    public final Card3D getBottomCard(int offset) {
        return offset >= 0 && offset < this.getTotalCards() ? this.getZoneCardList().get(offset) : null;
    }

    public void swapWithKnownAlternativeIfAvailable(Card3D chosenCard3D) {
        if (chosenCard3D.getCardIndex().isKnownByBothPlayers()) {
            return;
        }
        this.getZoneCardList().stream().filter(card3D -> card3D.getCardIndex().getImageSet().equals(chosenCard3D.getCardIndex().getImageSet()) && card3D.getCardIndex().isKnownByBothPlayers() && !this.isCardMarkedAsChosen((Card3D)card3D)).findFirst().ifPresent(altCard3D -> {
            CardIndex cardIndexAlt = altCard3D.getCardIndex();
            CardIndex cardIndexChosen = chosenCard3D.getCardIndex();
            chosenCard3D.setCardIndex(cardIndexAlt);
            altCard3D.setCardIndex(cardIndexChosen);
            Log.printMessage("!swapped: " + chosenCard3D.getCardIndex().getId() + " -> " + altCard3D.getCardIndex().getId());
        });
    }

    public void markCardAsChosen(Card3D card3D) {
        Log.printMessage("MARKED AS CHOSEN >>> " + String.valueOf(card3D));
        if (this.cacheChosenCards == null) {
            this.cacheChosenCards = new ArrayList();
        }
        if (!this.cacheChosenCards.contains(card3D)) {
            this.cacheChosenCards.add(card3D);
            if (this.cacheChosenCards.size() == 1) {
                this.shouldUpdateRandomizedCache = true;
            }
        }
    }

    private boolean isCardMarkedAsChosen(Card3D card3D) {
        return this.cacheChosenCards != null && this.cacheChosenCards.contains(card3D);
    }

    public Card3D getPrivateCard(String imageSet, int cardId, ZonePosition zonePosition) {
        Card3D card3D = null;
        if (imageSet != null) {
            card3D = this.getZoneCardList().stream().filter(c -> imageSet.equals(c.getCardIndex().getImageSet()) && c.getCardIndex().getId() == cardId && !c.shouldClearImageSet()).findAny().orElse(null);
        }
        if (card3D == null) {
            int i = 0;
            do {
                Card3D card3D2 = card3D = zonePosition == ZonePosition.TOP ? this.getTopCard(i++) : this.getBottomCard(i++);
            } while (card3D != null && card3D.getCardIndex().getIndexedInstance() != null && i < this.getTotalCards());
        }
        return card3D;
    }

    protected Card3D getRandomPrivateCard(String imageSet, int cardId) {
        if (this.shouldUpdateRandomizedCache) {
            this.cacheRandomizedCards = new ArrayList<Card3D>(this.getZoneCardList());
            Collections.shuffle(this.cacheRandomizedCards);
            if (this.cacheChosenCards != null) {
                for (int i = this.cacheChosenCards.size() - 1; i >= 0; --i) {
                    this.cacheRandomizedCards.addFirst(this.cacheChosenCards.get(i));
                }
            }
            this.shouldUpdateRandomizedCache = false;
            this.currentCachePos = 0;
        }
        if (this.cacheRandomizedCards == null || this.cacheRandomizedCards.isEmpty()) {
            return this.getTotalCards() > 0 ? this.getZoneCardList().get(UtilRandom.get_z(this.getTotalCards())) : null;
        }
        Card3D card3D = null;
        if (imageSet != null && (card3D = (Card3D)this.getZoneCardList().stream().filter(c -> imageSet.equals(c.getCardIndex().getImageSet()) && c.getCardIndex().getId() == cardId && !c.shouldClearImageSet()).findAny().orElse(null)) == null && Game.getCurrentGame().isNeutralPerspectiveGame()) {
            List<Card3D> listPrivateCards = this.getZoneCardList().stream().filter(c -> c.getCardIndex().getIndexedInstance() == null).toList();
            Card3D card3D2 = card3D = !listPrivateCards.isEmpty() ? listPrivateCards.get(ThreadLocalRandom.current().nextInt(listPrivateCards.size())) : null;
        }
        int n = card3D == null ? (imageSet == null ? this.currentCachePos : 0) : (this.currentCachePos = this.cacheRandomizedCards.indexOf(card3D));
        if (card3D == null || !Game.getCurrentGame().isNeutralPerspectiveGame()) {
            boolean hasLooped = false;
            do {
                if (this.currentCachePos < this.cacheRandomizedCards.size()) continue;
                if (hasLooped) break;
                this.currentCachePos = 0;
                hasLooped = true;
            } while ((card3D = this.cacheRandomizedCards.get(this.currentCachePos++)).getCardIndex().getIndexedInstance() != null && !card3D.shouldClearImageSet());
            if (card3D.getCardIndex().getIndexedInstance() != null) {
                if (!card3D.shouldClearImageSet()) {
                    Log.printMessage(true, "Warning: Replacing a card that shouldn't be cleared! No other options available. (" + String.valueOf(card3D) + " : " + card3D.getCardIndex().getImageSet() + ")");
                } else {
                    card3D.setShouldClearImageSet(false);
                }
                card3D.getCardIndex().clearImageSet();
                card3D.updateImageSet();
            }
        }
        this.cacheRandomizedCards.remove(card3D);
        return card3D;
    }

    public int getTotalCards() {
        return this.listCards.size();
    }

    public List<Card3D> getZoneCardList() {
        return this.listCards;
    }

    public int getLastModifiedIndex() {
        return this.lastModifiedIndex;
    }

    public Vector3D getNextCardOrigin() {
        return this.getNextCardOrigin(ZonePosition.TOP);
    }

    public Vector3D getNextCardOrigin(ZonePosition addPosition) {
        Vector3D origin = new Vector3D(this.node, Vector3D.VectorType.ORIGIN);
        Vector3D offset = this.getCardOriginOffset(addPosition == ZonePosition.TOP ? this.listCards.size() : 0);
        return Vector3D.add(origin, offset);
    }

    public Vector3D getNextCardRotation() {
        return this.getNextCardRotation(ZonePosition.TOP);
    }

    public Vector3D getNextCardRotation(ZonePosition addPosition) {
        return this.getCardRotation(addPosition == ZonePosition.TOP ? this.listCards.size() : 0);
    }

    public Vector3D getNextCardOriginAbsolute(Zone zoneStart, ZonePosition addPosition) {
        Point2D zoneStartScenePos = zoneStart.getNode().localToScene(0.0, 0.0);
        Vector3D originStart = new Vector3D(zoneStartScenePos.getX(), zoneStartScenePos.getY(), zoneStart.getCardOriginOffset(zoneStart.getLastModifiedIndex()).getZ());
        Point2D zoneEndScenePos = this.node.localToScene(0.0, 0.0);
        Vector3D originEnd = new Vector3D(zoneEndScenePos.getX(), zoneEndScenePos.getY(), 0.0);
        Vector3D offset = this.getCardOriginOffset(addPosition == ZonePosition.TOP ? this.listCards.size() : 0);
        return Vector3D.subtract(Vector3D.add(originEnd, offset), originStart);
    }

    protected Vector3D getCardOriginOffset(int i) {
        return Vector3D.ZERO;
    }

    protected Vector3D getCardRotation(int i) {
        return Vector3D.ZERO;
    }

    public abstract GameConst.CardLocation getZoneLocation();

    public void updateZone(OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType) {
    }

    final void setZoneListData(List<Card3D> listCards) {
        this.listCards = listCards;
    }

    @Override
    public void dispose() {
        this.listCards = null;
        this.cacheRandomizedCards = null;
        this.cacheChosenCards = null;
        this.listHandlersCardMoved = null;
        this.handlerAni = null;
    }

    public final boolean isFlipped() {
        return this.isFlipped;
    }

    public static boolean getShouldFlip() {
        return shouldFlip;
    }

    public static void setShouldFlip(boolean flip) {
        shouldFlip = flip;
    }

    public final Group3D getNode() {
        return this.node;
    }

    public static Game.GamePlayerRole getZoneOwner(Zone zone) {
        return Zone.getZoneOwner(zone.isFlipped());
    }

    public static Game.GamePlayerRole getZoneOwner(boolean isFlipped) {
        return isFlipped ? Game.GamePlayerRole.getOpponentRole(Game.getCurrentGame().getPlayerRole()) : Game.getCurrentGame().getPlayerRole();
    }

    @FunctionalInterface
    public static interface OnRearrangeAnimationInterpolateHandler {
        public void interpolate(double var1);

        public static enum RearrangeType {
            CARD_ADDED,
            CARD_REMOVED;

        }
    }

    public static enum ZonePosition {
        TOP,
        BOTTOM;

    }

    @FunctionalInterface
    public static interface OnCardMovedHandler {
        public void handle(Card3D var1, OnRearrangeAnimationInterpolateHandler.RearrangeType var2);
    }

    protected record RearrangeAnimationData(Card3D card3D, double start, double diff) {
    }
}

