/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldZone;
import open.batoru.game.FieldZoneNumbers;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;
import open.batoru.ui.UI;

public class ZoneEner
extends FieldZone {
    private static final Vector3D CARD_ROTATION = new Vector3D(0.0, 0.0, -90.0);
    private static final Vector3D CARD_SKEWED_ROTATION = new Vector3D(0.0, 2.0, -90.0);
    private static final double OFFSET_FIRST = -106.5;
    private static final double DEFAULT_SPACE = 87.0;
    private static final double FIT_SIZE = 696.0;
    private static final double OFFSET_PADDING = -1.0;
    private final FieldZoneNumbers zoneNumbers = new FieldZoneNumbers(FieldZoneNumbers.NumberTexture.GRADIENT);

    public ZoneEner(double x, double y) {
        super(x, y, 369, 973, FieldZone.ZoneType.ENER);
        this.zoneNumbers.setScale(0.6);
        this.zoneNumbers.setTransZ(-4.0);
        this.zoneNumbers.setTransX(219.5);
        this.zoneNumbers.setTransY(-447.5);
        if (ZoneEner.getShouldFlip()) {
            this.zoneNumbers.setRotateZ(180.0);
        }
        this.getNode().getChildren().add((Object)this.zoneNumbers);
        this.zoneNumbers.setValue(0.0);
    }

    public double calculateSpacing(int i, int offset) {
        if (i == 0) {
            return -106.5;
        }
        return 696.0 / (double)(this.getTotalCards() + offset < 9 ? 8 : this.getTotalCards() + offset);
    }

    private double calculateCardOffset(int i) {
        return -350.0 + (double)i * this.calculateSpacing(i, 0);
    }

    private double calculateCardOffsetY(int i, int offset) {
        return -106.5 + (double)i * this.calculateSpacing(i, offset) - -1.0;
    }

    @Override
    protected Vector3D getCardOriginOffset(int i) {
        return new Vector3D(0.0, this.calculateCardOffset(i), i > 0 ? -4.0 : 0.0);
    }

    @Override
    protected Vector3D getCardRotation(int i) {
        return i > 0 ? CARD_SKEWED_ROTATION : CARD_ROTATION;
    }

    @Override
    public void updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType) {
        if (rearrangeType == Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED) {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.getTopCard().getCardIndex());
        }
        this.zoneNumbers.setValue(this.getTotalCards());
    }

    @Override
    public void prepareRearrangeAnimation(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType, Zone.ZonePosition addPosition) {
        if (this.getZoneCardList().isEmpty()) {
            return;
        }
        int offset = rearrangeType == Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED ? 0 : -1;
        ArrayList<Zone.RearrangeAnimationData> listData = new ArrayList<Zone.RearrangeAnimationData>();
        for (int i = 0; i < this.getTotalCards(); ++i) {
            double end;
            Card3D card3D = this.getZoneCardList().get(i);
            double start = card3D.getTransY();
            double diff = start - (end = this.calculateCardOffsetY(i, offset));
            if (diff == 0.0) continue;
            listData.add(new Zone.RearrangeAnimationData(card3D, start, diff));
        }
        this.setOnRearrangeAnimationInterpolate(frac -> {
            for (Zone.RearrangeAnimationData data : listData) {
                data.card3D().setTransY(data.start() - data.diff() * frac);
            }
        });
    }

    @Override
    public GameConst.CardLocation getZoneLocation() {
        return GameConst.CardLocation.ENER;
    }
}

