/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import javafx.beans.property.StringProperty;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.Zone;
import open.batoru.game.ZoneLRIG;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;
import open.batoru.ui.UI;

public class ZoneLRIGAssist
extends ZoneLRIG {
    private final GameConst.CardLocation zoneLocation;

    public ZoneLRIGAssist(double x, double y, GameConst.CardLocation zoneLocation) {
        super(x, y, null, null);
        this.zoneLocation = zoneLocation;
    }

    @Override
    protected Vector3D getCardOriginOffset(int i) {
        return new Vector3D(0.0, 14.0, (double)(-i) * 4.0);
    }

    @Override
    public void removeCardFromZoneList(Card3D card3D) {
        super.removeCardFromZoneList(card3D);
        if (this.getZoneCardList().isEmpty() && Game.getCurrentGame().getGameServerPortOffset() != 0) {
            StringProperty imageProperty = this.zoneLocation == GameConst.CardLocation.LRIG_ASSIST_LEFT ? Game.getCurrentGame().getRoom().getPlayerData(Zone.getZoneOwner(this)).getLRIGAssistLeftImageProperty() : Game.getCurrentGame().getRoom().getPlayerData(Zone.getZoneOwner(this)).getLRIGAssistRightImageProperty();
            imageProperty.set((Object)"");
        }
    }

    @Override
    public void updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType) {
        Card3D card3D = this.getTopCard();
        if (!Card3D.isFaceUpOnField(card3D)) {
            return;
        }
        if (this.isFlipped()) {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(card3D.getCardIndex());
        }
        if (Game.getCurrentGame().getGameServerPortOffset() != 0) {
            StringProperty imageProperty = this.zoneLocation == GameConst.CardLocation.LRIG_ASSIST_LEFT ? Game.getCurrentGame().getRoom().getPlayerData(Zone.getZoneOwner(this)).getLRIGAssistLeftImageProperty() : Game.getCurrentGame().getRoom().getPlayerData(Zone.getZoneOwner(this)).getLRIGAssistRightImageProperty();
            imageProperty.set((Object)this.getTopCard().getCardIndex().getImageSet());
        }
    }

    @Override
    public GameConst.CardLocation getZoneLocation() {
        return this.zoneLocation;
    }
}

