/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javafx.scene.paint.Color;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.SIGNIZoneRuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.card.RuleCheckCanAttackSIGNIZone;
import open.batoru.data.ModifiableDouble;
import open.batoru.data.ModifiableVariable;
import open.batoru.game.FieldData;
import open.batoru.game.FieldStackZone;
import open.batoru.game.FieldZone;
import open.batoru.game.FieldZoneArrow;
import open.batoru.game.FieldZoneCrossIndicator;
import open.batoru.game.FieldZoneNumbers;
import open.batoru.game.PlayerField;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationZoneTracer;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class ZoneSIGNI
extends FieldStackZone
implements Disposable {
    private final GameConst.CardLocation zoneLocation;
    private final FieldZoneArrow zoneArrow = new FieldZoneArrow();
    private final FieldZoneNumbers zoneNumbers = new FieldZoneNumbers(FieldZoneNumbers.NumberTexture.GRADIENT);
    private Map<FieldZoneCrossIndicator.CrossPosition, FieldZoneCrossIndicator> mapZoneCross;
    private boolean isUpdateLocked;
    private ModifiableVariable.OnValueChangedHandler<Double> handleListenerPower;
    private ModifiableVariable.OnValueChangedHandler<Integer> handleListenerAttackModifierFlags;
    private ModifiableVariable.OnValueChangedHandler<Integer> handleListenerStateFlags;
    private CardIndex lastListenerOwner;
    private List<AnimationZoneTracer> aniAttackTrackers;

    public ZoneSIGNI(double x, double y, GameConst.CardLocation zoneLocation) {
        super(x, y, FieldZone.ZoneType.SIGNI);
        this.zoneLocation = zoneLocation;
        this.zoneArrow.setTransY(-235.0);
        this.getNode().getChildren().add((Object)this.zoneArrow);
        if (ZoneSIGNI.getShouldFlip()) {
            this.zoneNumbers.setRotateZ(180.0);
        }
        this.getNode().setOnMouseEntered(e -> this.onMouseEntered());
        this.getNode().setOnMouseExited(e -> this.onMouseExited());
    }

    @Override
    protected Vector3D getCardOriginOffset(int i) {
        return new Vector3D(0.0, -24.0, (double)(-i) * 4.0);
    }

    @Override
    public void addCardToZoneList(Card3D card3D, Zone.ZonePosition addPosition) {
        super.addCardToZoneList(card3D, addPosition);
        if (addPosition == Zone.ZonePosition.TOP) {
            Card3D card3DTop = this.getTopCard(1);
            if (card3DTop != null) {
                this.removeListeners(card3DTop.getCardIndex());
                card3DTop.getCardMeshFace().clearTextureLayers();
                if (card3DTop.getCardIndex().getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE) {
                    if (card3DTop.getCardIndex().getIndexedInstance() != null && !card3DTop.getCardIndex().getIndexedInstance().isState(256)) {
                        card3DTop.getCardIndex().getIndexedInstance().resetStats();
                    }
                    card3DTop.getCardIndex().setUnderType(GameConst.CardUnderType.UNDER_GENERIC);
                }
            }
            this.addListeners(card3D);
        } else if (card3D.getCardIndex().getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE) {
            card3D.getCardIndex().setUnderType(GameConst.CardUnderType.UNDER_GENERIC);
        }
    }

    @Override
    public void removeCardFromZoneList(Card3D card3D) {
        if (card3D == this.getTopCard()) {
            this.removeListeners(card3D.getCardIndex());
        }
        super.removeCardFromZoneList(card3D);
        if (this.getLastModifiedIndex() == this.getTotalCards()) {
            Card3D card3DUnder;
            GameConst.CardUnderCategory underCategory;
            for (int i = this.getTotalCards() - 1; i >= 0 && (underCategory = (card3DUnder = this.getZoneCardList().get(i)).getCardIndex().getUnderType().getUnderCategory()) != GameConst.CardUnderCategory.ZONE; --i) {
                if (underCategory == GameConst.CardUnderCategory.NONE) continue;
                card3DUnder.getCardIndex().getIndexedInstance().getCardStateFlags().addValue(256);
            }
        }
    }

    private void addListeners(Card3D card3D) {
        if (card3D.getCardIndex().getIndexedInstance() == null) {
            return;
        }
        this.handleListenerPower = (oldValue, newValue) -> this.zoneNumbers.adjustValue((Double)card3D.getCardIndex().getIndexedInstance().getPower().getBaseValue(), (double)oldValue, (double)newValue);
        this.handleListenerAttackModifierFlags = (oldValue, newValue) -> FX.run(() -> this.zoneArrow.updateAttackModifierFlags((int)newValue));
        this.handleListenerStateFlags = (oldValue, newValue) -> FX.run(() -> {
            this.updateStateFlagTexture(card3D, (int)oldValue, (int)newValue, 65536, UtilTextureLayer.TextureType.FROZEN);
            this.updateStateFlagTexture(card3D, (int)oldValue, (int)newValue, 0x100000, UtilTextureLayer.TextureType.AWAKENED);
            this.updateStateFlagTexture(card3D, (int)oldValue, (int)newValue, 0x200000, UtilTextureLayer.TextureType.DRIVE);
            if (this.mapZoneCross != null) {
                this.mapZoneCross.values().forEach(crossIndicator -> {
                    if (crossIndicator.getState() != FieldZoneCrossIndicator.CrossState.DISABLED) {
                        crossIndicator.updateState((int)newValue);
                    }
                });
            }
        });
        card3D.getCardIndex().getIndexedInstance().getPower().addValueListener(this.handleListenerPower);
        card3D.getCardIndex().getIndexedInstance().getAttackModifierFlags().addValueListener(this.handleListenerAttackModifierFlags);
        card3D.getCardIndex().getIndexedInstance().getCardStateFlags().addValueListener(this.handleListenerStateFlags);
        this.lastListenerOwner = card3D.getCardIndex();
    }

    public void removeListeners(CardIndex cardIndex) {
        if (cardIndex.getIndexedInstance() == null) {
            return;
        }
        cardIndex.getIndexedInstance().getPower().removeValueListener(this.handleListenerPower);
        cardIndex.getIndexedInstance().getAttackModifierFlags().removeValueListener(this.handleListenerAttackModifierFlags);
        cardIndex.getIndexedInstance().getCardStateFlags().removeValueListener(this.handleListenerStateFlags);
        this.lastListenerOwner = null;
    }

    public void resetListeners() {
        if (this.lastListenerOwner != null) {
            this.removeListeners(this.lastListenerOwner);
        }
        if (this.getTopCard() != null) {
            this.addListeners(this.getTopCard());
        }
    }

    private void updateStateFlagTexture(Card3D card3D, int oldValue, int newValue, int flag, UtilTextureLayer.TextureType textureType) {
        if ((oldValue & flag) == 0 && (newValue & flag) != 0) {
            card3D.getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(textureType));
        } else if ((oldValue & flag) != 0 && (newValue & flag) == 0) {
            card3D.getCardMeshFace().removeTextureLayer(textureType.getAlias());
        }
    }

    @Override
    public void updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType) {
        if (this.getNode().isHover()) {
            this.onMouseExited();
            this.onMouseEntered();
        }
        Card3D card3D = this.getTopCard();
        if (this.isUpdateLocked || !Card3D.isFaceUpOnField(card3D) || card3D.getCardIndex().getIndexedInstance().isState(256)) {
            this.zoneArrow.updateAttackModifierFlags(0);
            this.zoneNumbers.setVisible(false);
            this.uninstallAllZoneCrossIndicators();
            if (card3D == null || card3D.getCardIndex().getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE) {
                this.getZoneUnderCardsIndicators().clearAllCardIndicators();
            }
            return;
        }
        CardIndex cardIndex = card3D.getCardIndex();
        UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(cardIndex);
        this.zoneArrow.updateAttackModifierFlags(cardIndex.getIndexedInstance().getAttackModifierFlags().getValue());
        ModifiableDouble power = cardIndex.getIndexedInstance().getPower();
        this.zoneNumbers.setVisible(true);
        this.zoneNumbers.setValue(power.getValue());
        this.zoneNumbers.setColorByValue((Double)power.getBaseValue(), power.getValue());
    }

    public void installZoneNumbers(PlayerField field) {
        this.zoneNumbers.setTranslate(this.getNode().getTransX(), this.getNode().getTransY() + 185.0, this.getNode().getTransZ() - 2.0);
        field.getChildren().add((Object)this.zoneNumbers);
    }

    public FieldZoneCrossIndicator installZoneCrossIndicator(FieldZoneCrossIndicator.CrossPosition position) {
        if (this.mapZoneCross == null) {
            this.mapZoneCross = new EnumMap<FieldZoneCrossIndicator.CrossPosition, FieldZoneCrossIndicator>(FieldZoneCrossIndicator.CrossPosition.class);
        } else if (this.mapZoneCross.containsKey((Object)position)) {
            return this.mapZoneCross.get((Object)position);
        }
        FieldZoneCrossIndicator crossIndicator = new FieldZoneCrossIndicator(position);
        crossIndicator.setTranslate(this.getNode().getTransX() + (double)(position == FieldZoneCrossIndicator.CrossPosition.LEFT ? -1 : 1) * ((double)this.getWidth() * 0.5 + 15.0), this.getNode().getTransY() + -24.0, this.getNode().getTransZ() - 6.0);
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByZoneFlip(this.isFlipped()).getChildren().add((Object)crossIndicator);
        this.mapZoneCross.put(position, crossIndicator);
        return crossIndicator;
    }

    public FieldZoneCrossIndicator getZoneCrossIndicator(FieldZoneCrossIndicator.CrossPosition position) {
        return this.mapZoneCross != null ? this.mapZoneCross.get((Object)position) : null;
    }

    public void uninstallAllZoneCrossIndicators() {
        if (this.mapZoneCross == null) {
            return;
        }
        this.mapZoneCross.values().forEach(crossIndicator -> UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByZoneFlip(this.isFlipped()).getChildren().remove((Object)crossIndicator));
        this.mapZoneCross = null;
    }

    @Override
    public void installZoneAttachedAbilitiesIndicator(PlayerField field) {
        super.installZoneAttachedAbilitiesIndicator(field);
        this.getZoneAttachedAbilitiesIndicator().setTransX(this.getNode().getTransX() + 174.5 + 32.0);
    }

    public void setZoneUpdateLock(boolean lock) {
        this.isUpdateLocked = lock;
        if (!lock) {
            this.updateZone(null);
        }
    }

    private void onMouseEntered() {
        if (this.getTopCard() == null || this.getTopCard().getCardIndex().getIndexedInstance() == null || Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase().getId() != GameConst.GamePhase.ATTACK_SIGNI) {
            return;
        }
        CardIndex cardIndex = this.getTopCard().getCardIndex();
        RuleCheckCanAttackSIGNIZone ruleCheck = (RuleCheckCanAttackSIGNIZone)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.MUST_ATTACK_SIGNI_ZONE);
        if (ruleCheck.getRuleChecksNum() > 1) {
            if (this.aniAttackTrackers == null) {
                this.aniAttackTrackers = new ArrayList<AnimationZoneTracer>();
            }
            SIGNIZoneRuleCheck.SIGNIZonePositionGroup group = (SIGNIZoneRuleCheck.SIGNIZonePositionGroup)ruleCheck.check(cardIndex);
            for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
                if (group.getState(zonePosition) != SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState.ALLOW) continue;
                AnimationZoneTracer aniTracer = new AnimationZoneTracer(this, FieldData.getZoneByLocation(Game.GamePlayerRole.getOpponentRole(ZoneSIGNI.getZoneOwner(this)), zonePosition.getLocation()), Color.RED, "tracer_atk");
                this.aniAttackTrackers.add(aniTracer);
            }
            this.aniAttackTrackers.forEach(AnimationZoneTracer::play);
        }
    }

    private void onMouseExited() {
        if (this.aniAttackTrackers == null) {
            return;
        }
        this.aniAttackTrackers.forEach(AnimationZoneTracer::stop);
        this.aniAttackTrackers.clear();
    }

    public FieldZoneArrow getZoneArrow() {
        return this.zoneArrow;
    }

    public FieldZoneNumbers getZoneNumbers() {
        return this.zoneNumbers;
    }

    @Override
    public GameConst.CardLocation getZoneLocation() {
        return this.zoneLocation;
    }

    public static void transferCardListData(ZoneSIGNI zone1, ZoneSIGNI zone2) {
        int i;
        int i2;
        List<Card3D> listCards1 = zone1.getZoneCardList();
        List<Card3D> listCards2 = zone2.getZoneCardList();
        int skipped1 = 0;
        for (i2 = 0; i2 < listCards1.size(); ++i2) {
            if (listCards1.get(i2).getCardIndex().getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE) continue;
            skipped1 = i2 + 1;
            break;
        }
        for (i2 = 0; i2 < skipped1; ++i2) {
            Card3D card3D = listCards1.removeFirst();
            listCards2.add(i2, card3D);
        }
        int skipped2 = 0;
        for (i = skipped1; i < listCards2.size(); ++i) {
            if (listCards2.get(i).getCardIndex().getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE) continue;
            skipped2 = i + 1;
            break;
        }
        for (i = skipped1; i < skipped2; ++i) {
            Card3D card3D = listCards2.remove(skipped1);
            listCards1.add(i, card3D);
        }
        zone1.setZoneListData(listCards2);
        zone2.setZoneListData(listCards1);
        zone1.getZoneUnderCardsIndicators().clearAllCardIndicators();
        zone2.getZoneUnderCardsIndicators().clearAllCardIndicators();
        zone1.uninstallAllZoneCrossIndicators();
        zone2.uninstallAllZoneCrossIndicators();
        for (Card3D card3D : zone1.getZoneCardList()) {
            card3D.setOwnerZone(zone1);
            card3D.getCardIndex().setLocation(zone1.getZoneLocation());
            if (card3D.getCardIndex().getIndexedInstance() == null || card3D.getCardIndex().getUnderType().getUnderCategory() == GameConst.CardUnderCategory.ZONE) continue;
            zone1.getZoneUnderCardsIndicators().addUnderType(card3D.getCardIndex().getUnderType());
        }
        for (Card3D card3D : zone2.getZoneCardList()) {
            card3D.setOwnerZone(zone2);
            card3D.getCardIndex().setLocation(zone2.getZoneLocation());
            if (card3D.getCardIndex().getIndexedInstance() == null || card3D.getCardIndex().getUnderType().getUnderCategory() == GameConst.CardUnderCategory.ZONE) continue;
            zone2.getZoneUnderCardsIndicators().addUnderType(card3D.getCardIndex().getUnderType());
        }
        zone1.resetListeners();
        zone2.resetListeners();
        zone1.updateZone(null);
        zone2.updateZone(null);
    }

    @Override
    public void dispose() {
        this.getNode().setOnMouseEntered(null);
        this.getNode().setOnMouseExited(null);
        if (this.getTopCard() != null) {
            this.removeListeners(this.getTopCard().getCardIndex());
        }
        this.onMouseExited();
        this.handleListenerPower = null;
        this.handleListenerStateFlags = null;
        this.handleListenerAttackModifierFlags = null;
        this.lastListenerOwner = null;
        super.dispose();
    }
}

