/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d;

import javafx.scene.image.Image;
import open.batoru.game._3d.LayeredTexturedMesh;

public class CardMeshPlane
extends LayeredTexturedMesh {
    private static final float W = 125.0f;
    private static final float H = 174.5f;
    private static final float WQ = 62.5f;
    private static final float HQ = 87.25f;
    private static final float[] POINTS = new float[]{-125.0f, -164.5f, 0.0f, -123.75f, -168.0f, 0.0f, -121.25f, -170.75f, 0.0f, -118.5f, -173.25f, 0.0f, -115.0f, -174.5f, 0.0f, -62.5f, -174.5f, 0.0f, 0.0f, -174.5f, 0.0f, 62.5f, -174.5f, 0.0f, 115.0f, -174.5f, 0.0f, 118.5f, -173.25f, 0.0f, 121.25f, -170.75f, 0.0f, 123.75f, -168.0f, 0.0f, 125.0f, -164.5f, 0.0f, 125.0f, -87.25f, 0.0f, 125.0f, 0.0f, 0.0f, 125.0f, 87.25f, 0.0f, 125.0f, 164.5f, 0.0f, 123.75f, 168.0f, 0.0f, 121.25f, 170.75f, 0.0f, 118.5f, 173.25f, 0.0f, 115.0f, 174.5f, 0.0f, 62.5f, 174.5f, 0.0f, 0.0f, 174.5f, 0.0f, -62.5f, 174.5f, 0.0f, -115.0f, 174.5f, 0.0f, -118.5f, 173.25f, 0.0f, -121.25f, 170.75f, 0.0f, -123.75f, 168.0f, 0.0f, -125.0f, 164.5f, 0.0f, -125.0f, 87.25f, 0.0f, -125.0f, 0.0f, 0.0f, -125.0f, -87.25f, 0.0f, -62.5f, -87.25f, 0.0f, 0.0f, -87.25f, 0.0f, 62.5f, -87.25f, 0.0f, -62.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 62.5f, 0.0f, 0.0f, -62.5f, 87.25f, 0.0f, 0.0f, 87.25f, 0.0f, 62.5f, 87.25f, 0.0f};
    private static final float[] TEX_COORDS = new float[]{0.0f, 0.029f, 0.005f, 0.019f, 0.015f, 0.011f, 0.026f, 0.004f, 0.04f, 0.0f, 0.25f, 0.0f, 0.5f, 0.0f, 0.75f, 0.0f, 0.96f, 0.0f, 0.974f, 0.004f, 0.985f, 0.011f, 0.995f, 0.019f, 1.0f, 0.029f, 1.0f, 0.25f, 1.0f, 0.5f, 1.0f, 0.75f, 1.0f, 0.971f, 0.995f, 0.981f, 0.985f, 0.989f, 0.974f, 0.996f, 0.96f, 1.0f, 0.75f, 1.0f, 0.5f, 1.0f, 0.25f, 1.0f, 0.04f, 1.0f, 0.026f, 0.996f, 0.015f, 0.989f, 0.005f, 0.981f, 0.0f, 0.971f, 0.0f, 0.75f, 0.0f, 0.5f, 0.0f, 0.25f, 0.25f, 0.25f, 0.5f, 0.25f, 0.75f, 0.25f, 0.25f, 0.5f, 0.5f, 0.5f, 0.75f, 0.5f, 0.25f, 0.75f, 0.5f, 0.75f, 0.75f, 0.75f};
    private static final int[] FACES = new int[]{3, 3, 2, 2, 32, 32, 4, 4, 3, 3, 32, 32, 5, 5, 4, 4, 32, 32, 6, 6, 5, 5, 32, 32, 6, 6, 32, 32, 33, 33, 6, 6, 33, 33, 34, 34, 7, 7, 6, 6, 34, 34, 7, 7, 34, 34, 8, 8, 8, 8, 34, 34, 9, 9, 9, 9, 34, 34, 10, 10, 11, 11, 10, 10, 34, 34, 12, 12, 11, 11, 34, 34, 13, 13, 12, 12, 34, 34, 14, 14, 13, 13, 34, 34, 34, 34, 37, 37, 14, 14, 14, 14, 37, 37, 40, 40, 15, 15, 14, 14, 40, 40, 40, 40, 16, 16, 15, 15, 17, 17, 16, 16, 40, 40, 18, 18, 17, 17, 40, 40, 19, 19, 18, 18, 40, 40, 20, 20, 19, 19, 40, 40, 21, 21, 20, 20, 40, 40, 21, 21, 40, 40, 22, 22, 22, 22, 40, 40, 39, 39, 22, 22, 39, 39, 38, 38, 22, 22, 38, 38, 23, 23, 38, 38, 24, 24, 23, 23, 25, 25, 24, 24, 38, 38, 26, 26, 25, 25, 38, 38, 27, 27, 26, 26, 38, 38, 28, 28, 27, 27, 38, 38, 29, 29, 28, 28, 38, 38, 30, 30, 29, 29, 38, 38, 38, 38, 35, 35, 30, 30, 30, 30, 35, 35, 32, 32, 32, 32, 31, 31, 30, 30, 32, 32, 0, 0, 31, 31, 1, 1, 0, 0, 32, 32, 2, 2, 1, 1, 32, 32, 36, 36, 32, 32, 35, 35, 36, 36, 33, 33, 32, 32, 34, 34, 33, 33, 36, 36, 34, 34, 36, 36, 37, 37, 37, 37, 36, 36, 40, 40, 40, 40, 36, 36, 39, 39, 36, 36, 38, 38, 39, 39, 36, 36, 35, 35, 38, 38};

    public CardMeshPlane(Image cardImage) {
        super(cardImage);
        this.getMesh().getPoints().setAll(POINTS);
        this.getMesh().getTexCoords().setAll(TEX_COORDS);
        this.getMesh().getFaces().setAll(FACES);
    }

    public CardMeshPlane(Image cardImage, int faceId) {
        super(cardImage);
        int[] face = CardMeshPlane.getFace(faceId);
        for (int i = 0; i < 3; ++i) {
            int p = face[i * 2];
            int t = face[i * 2 + 1];
            float[] point = CardMeshPlane.getPoint(p);
            float[] texCoord = CardMeshPlane.getTexCoord(t);
            this.getMesh().getPoints().addAll(point);
            this.getMesh().getTexCoords().addAll(texCoord);
        }
        this.getMesh().getFaces().setAll(new int[]{0, 0, 1, 1, 2, 2});
    }

    public static int getTotalPoints(boolean includeInner) {
        return (includeInner ? POINTS.length : POINTS.length - 27) / 3;
    }

    public static int getTotalTexCoords(boolean includeInner) {
        return (includeInner ? TEX_COORDS.length : TEX_COORDS.length - 18) / 2;
    }

    public static int getTotalFaces(boolean includeInner) {
        return (includeInner ? FACES.length : FACES.length - 8) / 6;
    }

    public static int utilGetYSymmetricalFace(int faceId) {
        if (faceId >= 0 && faceId < CardMeshPlane.getTotalFaces(true)) {
            if (faceId < 40) {
                return (9 - faceId + 40) % 40;
            }
            if (faceId <= 43) {
                return 43 - faceId + 40;
            }
            if (faceId <= 47) {
                return 47 - faceId + 44;
            }
        }
        return -1;
    }

    public static float[] getPoint(int id) {
        if ((id *= 3) < 0 || id >= POINTS.length) {
            return null;
        }
        float[] point = new float[3];
        System.arraycopy(POINTS, id, point, 0, 3);
        return point;
    }

    public static float[] getTexCoord(int id) {
        if ((id *= 2) < 0 || id >= TEX_COORDS.length) {
            return null;
        }
        float[] texCoord = new float[2];
        System.arraycopy(TEX_COORDS, id, texCoord, 0, 2);
        return texCoord;
    }

    public static int[] getFace(int id) {
        if ((id *= 6) < 0 || id >= FACES.length) {
            return null;
        }
        int[] face = new int[6];
        System.arraycopy(FACES, id, face, 0, 6);
        return face;
    }
}

