/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d;

import javafx.scene.Node;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.game.FieldZoneNumbers;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;

public class GizmoCraft
extends Group3D {
    private final Plane meshGearBig;
    private final Plane meshGearSmall;
    private final FieldZoneNumbers numbers;
    private static final Color color = Color.PALEGREEN;

    public GizmoCraft(boolean isVertical) {
        Plane meshBorder = new Plane(349, 450, ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("craft/border")));
        this.meshGearBig = new Plane(151, ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("craft/gear_big")));
        this.meshGearSmall = new Plane(79, ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("craft/gear_small")));
        Plane meshText = new Plane(127, 75, ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("craft/text")));
        this.numbers = new FieldZoneNumbers(FieldZoneNumbers.NumberTexture.OUTLINE);
        this.numbers.setScale(0.6);
        this.numbers.setValue(0.0);
        meshBorder.getMaterial().setDiffuseColor(color);
        this.meshGearBig.getMaterial().setDiffuseColor(color);
        this.meshGearSmall.getMaterial().setDiffuseColor(color);
        meshText.getMaterial().setDiffuseColor(color);
        this.numbers.setColor(color);
        if (isVertical) {
            this.meshGearBig.setTranslate(-94.0, 141.0, -8.0);
            this.meshGearSmall.setTranslate(-18.0, 66.0, -8.0);
            this.numbers.setTranslate(68.0, 195.0, -8.0);
            meshText.setTranslate(97.0, 175.0, -8.0);
        } else {
            this.meshGearBig.setTranslate(-144.0, 91.0, -8.0);
            this.meshGearSmall.setTranslate(-68.0, 16.0, -8.0);
            this.numbers.setTranslate(118.0, 145.0, -8.0);
            meshText.setTranslate(147.0, 125.0, -8.0);
            meshBorder.setRotateZ(90.0);
        }
        this.getChildren().addAll((Object[])new Node[]{meshBorder, this.meshGearBig, this.meshGearSmall, meshText, this.numbers});
    }

    public void setGearRotate(double angle) {
        this.meshGearBig.setRotateZ(angle);
        this.meshGearSmall.setRotateZ(-angle);
    }

    public void setPercentValue(double value) {
        this.numbers.setValue(value);
    }
}

