/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d;

import open.batoru.ImageCache;
import open.batoru.UtilRandom;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;

public class GizmoResona
extends Group3D {
    public static final int MAX_CIRCLES = 5;
    private final GizmoResonaCircle[] listCircles;
    private int numDescendedCircles;

    public GizmoResona(int numCircles) {
        this.listCircles = new GizmoResonaCircle[Math.min(numCircles, 5)];
        for (int i = 0; i < this.listCircles.length; ++i) {
            this.listCircles[i] = new GizmoResonaCircle(i);
            this.getChildren().add((Object)this.listCircles[i]);
        }
    }

    public GizmoResonaCircle getCircle(int circleId) {
        return circleId >= 0 && circleId < this.listCircles.length ? this.listCircles[circleId] : null;
    }

    public int getCirclesCount() {
        return this.listCircles.length;
    }

    public int getDescendedCirclesCount() {
        return this.numDescendedCircles;
    }

    public class GizmoResonaCircle
    extends Group3D {
        private static final int SIZE_INITIAL = 744;
        private static final int SIZE_STEP = 140;
        private final int id;
        private final Plane mesh;

        public GizmoResonaCircle(int id) {
            this.id = id;
            this.mesh = new Plane(744 + id * 140, ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("resona/circle" + (id + 1))));
            this.setTransZ(-2000.0);
            this.setRotateZ(UtilRandom.get_z(360) - (id % 2 == 0 ? 0 : 360));
            this.getChildren().add((Object)this.mesh);
            this.setMouseTransparent(true);
        }

        public void markAsDescended() {
            ++GizmoResona.this.numDescendedCircles;
        }

        public int getCircleId() {
            return this.id;
        }

        public Plane getMesh() {
            return this.mesh;
        }
    }
}

