/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Group;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import open.batoru.game._3d.Vector3D;

public class Group3D
extends Group {
    private final Translate translate = new Translate();
    private final Rotate rotateX = new Rotate();
    private final Rotate rotateY = new Rotate();
    private final Rotate rotateZ = new Rotate();
    private final Scale scale = new Scale();
    private List<OnVectorChangedHandler> handlersTranslate;

    public Group3D() {
        this.rotateX.setAxis(Rotate.X_AXIS);
        this.rotateY.setAxis(Rotate.Y_AXIS);
        this.rotateZ.setAxis(Rotate.Z_AXIS);
        this.getTransforms().addAll((Object[])new Transform[]{this.translate, this.rotateZ, this.rotateY, this.rotateX, this.scale});
    }

    public void setTranslate(double x, double y, double z) {
        this.translate.setX(x);
        this.translate.setY(y);
        this.translate.setZ(z);
        this.notifyTranslateChanged();
    }

    public void setTranslate(double x, double y) {
        this.translate.setX(x);
        this.translate.setY(y);
        this.notifyTranslateChanged();
    }

    public void setTranslate(Group3D node) {
        this.translate.setX(node.getTransX());
        this.translate.setY(node.getTransY());
        this.translate.setZ(node.getTransZ());
        this.notifyTranslateChanged();
    }

    public void setTranslate(Vector3D vector) {
        this.translate.setX(vector.getX());
        this.translate.setY(vector.getY());
        this.translate.setZ(vector.getZ());
        this.notifyTranslateChanged();
    }

    public void setTranslate(Vector3D vector1, Vector3D vector2, double scalar) {
        this.translate.setX(vector1.getX() + vector2.getX() * scalar);
        this.translate.setY(vector1.getY() + vector2.getY() * scalar);
        this.translate.setZ(vector1.getZ() + vector2.getZ() * scalar);
        this.notifyTranslateChanged();
    }

    public void setTransX(double x) {
        this.translate.setX(x);
        this.notifyTranslateChanged();
    }

    public void setTransY(double y) {
        this.translate.setY(y);
        this.notifyTranslateChanged();
    }

    public void setTransZ(double z) {
        this.translate.setZ(z);
        this.notifyTranslateChanged();
    }

    public double getTransX() {
        return this.translate.getX();
    }

    public double getTransY() {
        return this.translate.getY();
    }

    public double getTransZ() {
        return this.translate.getZ();
    }

    private void notifyTranslateChanged() {
        if (this.handlersTranslate != null) {
            for (OnVectorChangedHandler handler : this.handlersTranslate) {
                handler.handle(this.translate.getX(), this.translate.getY(), this.translate.getZ());
            }
        }
    }

    public void setOnTranslated(OnVectorChangedHandler handler) {
        if (this.handlersTranslate == null) {
            this.handlersTranslate = new ArrayList<OnVectorChangedHandler>();
        }
        this.handlersTranslate.add(handler);
    }

    public void removeOnTranslatedHandler(OnVectorChangedHandler handler) {
        this.handlersTranslate.remove(handler);
    }

    public void setRotate(double x, double y, double z) {
        this.rotateX.setAngle(x);
        this.rotateY.setAngle(y);
        this.rotateZ.setAngle(z);
    }

    public void setRotate(Group3D node) {
        this.rotateX.setAngle(node.getRotateX());
        this.rotateY.setAngle(node.getRotateY());
        this.rotateZ.setAngle(node.getRotateZ());
    }

    public void setRotate(Vector3D vector) {
        this.rotateX.setAngle(vector.getX());
        this.rotateY.setAngle(vector.getY());
        this.rotateZ.setAngle(vector.getZ());
    }

    public void setRotate(Vector3D vector, double scalar) {
        this.rotateX.setAngle(vector.getX() * scalar);
        this.rotateY.setAngle(vector.getY() * scalar);
        this.rotateZ.setAngle(vector.getZ() * scalar);
    }

    public void setRotate(Vector3D vector1, Vector3D vector2, double scalar) {
        this.rotateX.setAngle(vector1.getX() + vector2.getX() * scalar);
        this.rotateY.setAngle(vector1.getY() + vector2.getY() * scalar);
        this.rotateZ.setAngle(vector1.getZ() + vector2.getZ() * scalar);
    }

    public void setRotateX(double x) {
        this.rotateX.setAngle(x);
    }

    public void setRotateY(double y) {
        this.rotateY.setAngle(y);
    }

    public void setRotateZ(double z) {
        this.rotateZ.setAngle(z);
    }

    public double getRotateX() {
        return this.rotateX.getAngle();
    }

    public double getRotateY() {
        return this.rotateY.getAngle();
    }

    public double getRotateZ() {
        return this.rotateZ.getAngle();
    }

    public void setPivot(double x, double y, double z) {
        this.rotateX.setPivotX(x);
        this.rotateY.setPivotX(x);
        this.rotateZ.setPivotX(x);
        this.rotateX.setPivotY(y);
        this.rotateY.setPivotY(y);
        this.rotateZ.setPivotY(y);
        this.rotateX.setPivotZ(z);
        this.rotateY.setPivotZ(z);
        this.rotateZ.setPivotZ(z);
    }

    public void setScale(double factor) {
        this.scale.setX(factor);
        this.scale.setY(factor);
        this.scale.setZ(factor);
    }

    @FunctionalInterface
    public static interface OnVectorChangedHandler {
        public void handle(double var1, double var3, double var5);
    }
}

