/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.effect.Blend;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import open.batoru.core.Disposable;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.textures.ColorTextureLayer;
import open.batoru.game._3d.textures.CompositeTextureLayer;
import open.batoru.game._3d.textures.EffectTextureLayer;
import open.batoru.game._3d.textures.ImageTextureLayer;
import open.batoru.game._3d.textures.PostProcessPixelTextureLayer;
import open.batoru.game._3d.textures.TextureLayer;
import open.batoru.game._3d.textures.UtilTexture;

public class LayeredTexturedMesh
extends Group3D
implements Disposable {
    private final TriangleMesh mesh = new TriangleMesh();
    private final PhongMaterial material = new PhongMaterial();
    private final ImageView defaultTexture = new ImageView();
    private final StackPane layersDiffuse = new StackPane();
    private final StackPane layersSelfIllumination = new StackPane();
    private final List<Color> layersColors = new ArrayList<Color>();
    private final List<Effect> layersEffects = new ArrayList<Effect>();
    private final List<CompositeTextureLayer> layersComposites = new ArrayList<CompositeTextureLayer>();
    private final List<PostProcessPixelTextureLayer.PostProcessPixelHandler> layersPostProcess = new ArrayList<PostProcessPixelTextureLayer.PostProcessPixelHandler>();
    private final List<TextureLayer<?>> layers = new ArrayList();

    public LayeredTexturedMesh(Image texture) {
        MeshView render = new MeshView();
        render.setMesh((Mesh)this.mesh);
        render.setMaterial((Material)this.material);
        this.layersDiffuse.getChildren().add((Object)this.defaultTexture);
        if (texture != null) {
            this.setDefaultTexture(texture);
        }
        this.layersDiffuse.setPrefSize(250.0, 349.0);
        this.layersSelfIllumination.setPrefSize(250.0, 349.0);
        this.getChildren().add((Object)render);
    }

    public final void setDefaultTexture(Image texture) {
        this.defaultTexture.setImage(texture);
        this.updateMaterialTextureDiffuse();
    }

    public void addTextureLayer(TextureLayer<?> layer) {
        if (layer instanceof ImageTextureLayer) {
            ImageTextureLayer imageTextureLayer = (ImageTextureLayer)layer;
            if (imageTextureLayer.getImageLayerType() == ImageTextureLayer.ImageLayerType.DIFFUSE) {
                this.layersDiffuse.getChildren().add((Object)((Node)imageTextureLayer.getProvided()));
                this.updateMaterialTextureDiffuse();
            } else {
                this.layersSelfIllumination.getChildren().add((Object)((Node)imageTextureLayer.getProvided()));
                this.updateMaterialTextureSelfIllumination();
            }
        } else if (layer instanceof CompositeTextureLayer) {
            CompositeTextureLayer compositeTextureLayer = (CompositeTextureLayer)layer;
            this.layersComposites.add(compositeTextureLayer);
            this.updateMaterialTextureDiffuse();
        } else if (layer instanceof EffectTextureLayer) {
            EffectTextureLayer effectTextureLayer = (EffectTextureLayer)layer;
            this.layersEffects.add((Effect)effectTextureLayer.getProvided());
            this.updateMaterialTextureDiffuse();
        } else if (layer instanceof ColorTextureLayer) {
            ColorTextureLayer colorTextureLayer = (ColorTextureLayer)layer;
            this.layersColors.add((Color)colorTextureLayer.getProvided());
            this.updateMaterialColor();
        } else if (layer instanceof PostProcessPixelTextureLayer) {
            PostProcessPixelTextureLayer postProcessTextureLayer = (PostProcessPixelTextureLayer)layer;
            this.layersPostProcess.add((PostProcessPixelTextureLayer.PostProcessPixelHandler)postProcessTextureLayer.getProvided());
            this.updateMaterialTextureDiffuse();
        }
        this.layers.add(layer);
    }

    public void removeTextureLayer(TextureLayer<?> layer) {
        if (!this.layers.remove(layer)) {
            return;
        }
        if (layer instanceof ImageTextureLayer) {
            ImageTextureLayer imageTextureLayer = (ImageTextureLayer)layer;
            if (imageTextureLayer.getImageLayerType() == ImageTextureLayer.ImageLayerType.DIFFUSE) {
                if (this.layersDiffuse.getChildren().remove(imageTextureLayer.getProvided())) {
                    this.updateMaterialTextureDiffuse();
                }
            } else if (this.layersSelfIllumination.getChildren().remove(imageTextureLayer.getProvided())) {
                this.updateMaterialTextureSelfIllumination();
            }
        } else if (layer instanceof CompositeTextureLayer) {
            CompositeTextureLayer compositeTextureLayer = (CompositeTextureLayer)layer;
            this.layersComposites.remove(compositeTextureLayer);
            this.updateMaterialTextureDiffuse();
        } else if (layer instanceof EffectTextureLayer) {
            EffectTextureLayer effectTextureLayer = (EffectTextureLayer)layer;
            this.layersEffects.remove(effectTextureLayer.getProvided());
            this.updateMaterialTextureDiffuse();
        } else if (layer instanceof ColorTextureLayer) {
            ColorTextureLayer colorTextureLayer = (ColorTextureLayer)layer;
            this.layersColors.remove(colorTextureLayer.getProvided());
            this.updateMaterialColor();
        } else if (layer instanceof PostProcessPixelTextureLayer) {
            PostProcessPixelTextureLayer postProcessPixelTextureLayer = (PostProcessPixelTextureLayer)layer;
            this.layersPostProcess.remove(postProcessPixelTextureLayer.getProvided());
            this.updateMaterialTextureDiffuse();
        }
    }

    public void removeTextureLayer(String alias) {
        this.layers.stream().filter(layer -> layer.getAlias().equals(alias)).findFirst().ifPresent(this::removeTextureLayer);
    }

    public void clearTextureLayers() {
        this.layers.clear();
        this.layersColors.clear();
        this.layersEffects.clear();
        this.layersPostProcess.clear();
        this.layersComposites.clear();
        this.layersDiffuse.getChildren().retainAll((Object[])new Node[]{this.defaultTexture});
        this.layersSelfIllumination.getChildren().clear();
        this.updateMaterialTextureDiffuse();
        this.updateMaterialTextureSelfIllumination();
        this.updateMaterialColor();
    }

    private void updateMaterialTextureDiffuse() {
        if (this.layersDiffuse.getChildren().size() == 1 && this.layersEffects.isEmpty() && this.layersPostProcess.isEmpty() && this.layersComposites.isEmpty()) {
            this.material.setDiffuseMap(this.defaultTexture.getImage());
        } else {
            if (this.layersEffects.isEmpty()) {
                this.layersDiffuse.setEffect(null);
            } else {
                Effect effectChain = this.layersEffects.getFirst();
                for (int i = 1; i < this.layersEffects.size(); ++i) {
                    Blend blend = new Blend();
                    blend.setBottomInput(effectChain);
                    blend.setTopInput(this.layersEffects.get(i));
                    effectChain = blend;
                }
                this.layersDiffuse.setEffect(effectChain);
            }
            WritableImage snapshot = new WritableImage(250, 349);
            this.layersDiffuse.snapshot(new SnapshotParameters(), snapshot);
            for (PostProcessPixelTextureLayer.PostProcessPixelHandler postProcessPixelHandler : this.layersPostProcess) {
                snapshot = PostProcessPixelTextureLayer.apply((Image)snapshot, postProcessPixelHandler);
            }
            for (CompositeTextureLayer compositeTextureLayer : this.layersComposites) {
                WritableImage snapshotComposite = new WritableImage(250, 349);
                SnapshotParameters params = new SnapshotParameters();
                params.setFill((Paint)Color.TRANSPARENT);
                StackPane wrapper = new StackPane(new Node[]{(Node)compositeTextureLayer.getProvided()});
                wrapper.layout();
                ((StackPane)compositeTextureLayer.getProvided()).snapshot(params, snapshotComposite);
                snapshot = UtilTexture.combine((Image)snapshotComposite, (Image)snapshot);
            }
            this.material.setDiffuseMap((Image)snapshot);
        }
    }

    private void updateMaterialTextureSelfIllumination() {
        if (this.layersSelfIllumination.getChildren().isEmpty()) {
            this.material.setSelfIlluminationMap(null);
        } else if (this.layersSelfIllumination.getChildren().size() == 1) {
            this.material.setSelfIlluminationMap(((ImageView)this.layersSelfIllumination.getChildren().getFirst()).getImage());
        } else {
            WritableImage snapshot = new WritableImage(250, 349);
            SnapshotParameters params = new SnapshotParameters();
            params.setFill((Paint)Color.TRANSPARENT);
            this.layersSelfIllumination.snapshot(params, snapshot);
            this.material.setSelfIlluminationMap((Image)snapshot);
        }
    }

    private void updateMaterialColor() {
        if (this.layersColors.isEmpty()) {
            this.material.setDiffuseColor(Color.WHITE);
        } else {
            for (Color color : this.layersColors) {
                this.material.setDiffuseColor(this.material.getDiffuseColor().interpolate(color, this.material.getDiffuseColor() == Color.WHITE ? 1.0 : 0.5));
            }
        }
    }

    public Image getDefaultTexture() {
        return this.defaultTexture.getImage();
    }

    public Image getTexture() {
        return this.material.getDiffuseMap();
    }

    protected TriangleMesh getMesh() {
        return this.mesh;
    }

    @Override
    public void dispose() {
        this.layers.clear();
        this.layersColors.clear();
        this.layersEffects.clear();
        this.layersPostProcess.clear();
        this.layersDiffuse.getChildren().clear();
        this.layersSelfIllumination.getChildren().clear();
        this.defaultTexture.setImage(null);
        this.material.setDiffuseMap(null);
        this.material.setSelfIlluminationMap(null);
    }
}

