/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d;

import javafx.scene.shape.CullFace;
import open.batoru.ImageCache;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.Zone;
import open.batoru.game._3d.Plane;
import open.batoru.ui.UI;

public class MagicBoxLid
extends Plane {
    private final boolean isLeft;
    private Zone zone;

    public MagicBoxLid(boolean isLeft) {
        super(175, 450, ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("magic_box/lid_half")));
        this.getMaterial().setDiffuseColor(GameConst.CardUnderType.ZONE_MAGIC_BOX.getColor());
        this.setPivot(87.5 * (double)(isLeft ? -1 : 1), 0.0, 0.0);
        if (!isLeft) {
            this.getMesh().getTexCoords().setAll(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f});
        }
        this.getRender().setCullFace(CullFace.NONE);
        this.isLeft = isLeft;
    }

    public void addToZone(Zone zone) {
        this.setTransX(zone.getNode().getTransX() - (double)(175 * (this.isLeft ? 1 : -1)) * 0.5);
        this.setTransY(zone.getNode().getTransY());
        this.setTransZ(zone.getNode().getTransZ() + 2.0);
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(Zone.getZoneOwner(zone)).getChildren().add((Object)this);
        this.zone = zone;
    }

    public void removeFromZone() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(Zone.getZoneOwner(this.zone)).getChildren().remove((Object)this);
    }

    public boolean isLeft() {
        return this.isLeft;
    }
}

