/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d;

import open.batoru.game._3d.Group3D;

public class Vector3D {
    public static final Vector3D ZERO = new Vector3D(0.0, 0.0, 0.0);
    private double x;
    private double y;
    private double z;

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D(Vector3D vector, double offsetX, double offsetY, double offsetZ) {
        this.x = vector.getX() + offsetX;
        this.y = vector.getY() + offsetY;
        this.z = vector.getZ() + offsetZ;
    }

    public Vector3D(Group3D node, VectorType vectorType) {
        if (vectorType == VectorType.ORIGIN) {
            this.x = node.getTransX();
            this.y = node.getTransY();
            this.z = node.getTransZ();
        } else {
            this.x = node.getRotateX() % 360.0;
            this.y = node.getRotateY() % 360.0;
            this.z = node.getRotateZ() % 360.0;
        }
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public static Vector3D add(Vector3D vector1, Vector3D vector2) {
        return new Vector3D(vector1.getX() + vector2.getX(), vector1.getY() + vector2.getY(), vector1.getZ() + vector2.getZ());
    }

    public static Vector3D subtract(Vector3D vector1, Vector3D vector2) {
        return new Vector3D(vector1.getX() - vector2.getX(), vector1.getY() - vector2.getY(), vector1.getZ() - vector2.getZ());
    }

    public boolean equals(Vector3D vector) {
        return this.x == vector.getX() && this.y == vector.getY() && this.z == vector.getZ();
    }

    public static enum VectorType {
        ORIGIN,
        ROTATION;

    }
}

