/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d.textures;

import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.CardConst;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.game._3d.textures.CompositeTextureLayer;
import open.batoru.game._3d.textures.UtilTexture;

public class CostTextureLayer
extends CompositeTextureLayer {
    private final FlowPane flowPane;

    public CostTextureLayer(String alias) {
        super(alias);
        ((StackPane)this.getProvided()).setAlignment(Pos.TOP_CENTER);
        this.flowPane = new FlowPane(Orientation.HORIZONTAL);
        this.flowPane.setAlignment(Pos.TOP_CENTER);
        this.flowPane.setHgap(5.0);
        this.flowPane.setVgap(5.0);
        StackPane.setMargin((Node)this.flowPane, (Insets)new Insets(50.0, 0.0, 0.0, 0.0));
        ImageView iconArrow = new ImageView((Image)UtilTexture.colorize(ImageCache.INSTANCE.getImage("textures/zones/arrows/default.png"), Color.RED));
        ((StackPane)this.getProvided()).getChildren().addAll((Object[])new Node[]{iconArrow, this.flowPane});
    }

    public void addIcon(AbilityCost cost) {
        if (cost instanceof EnerCost) {
            EnerCost enerCost = (EnerCost)cost;
            for (char c : enerCost.getCostString().getValue().toCharArray()) {
                this.flowPane.getChildren().add((Object)new ImageView((Image)UtilTexture.colorize(ImageCache.INSTANCE.getImage(ImageCache.getColorTexturePath(CardConst.CardColor.getColorByShortLabel(c))), Color.RED)));
            }
        } else {
            TargetFilter.TargetHint hintTargetType = cost.getFilter() == null || cost.getFilter().getHintTargetType() == TargetFilter.TargetHint.GENERIC ? cost.getDefaultTargetHintType() : cost.getFilter().getHintTargetType();
            for (int i = 0; i < cost.getCostMinCount(); ++i) {
                ImageView icon = new ImageView((Image)UtilTexture.colorize(ImageCache.INSTANCE.getImage(ImageCache.getBorderIconTexturePath(hintTargetType)), Color.RED));
                icon.setScaleX(1.2);
                icon.setScaleY(1.2);
                this.flowPane.getChildren().add((Object)icon);
            }
        }
    }
}

