/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d.textures;

import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;

public class UtilTexture {
    public static WritableImage grayscale(Image image) {
        PixelReader reader = image.getPixelReader();
        WritableImage texture = new WritableImage(reader, (int)image.getWidth(), (int)image.getHeight());
        PixelWriter writer = texture.getPixelWriter();
        int x = 0;
        while ((double)x < texture.getWidth()) {
            int y = 0;
            while ((double)y < texture.getHeight()) {
                writer.setColor(x, y, reader.getColor(x, y).grayscale());
                ++y;
            }
            ++x;
        }
        return texture;
    }

    public static WritableImage cutout(Image image) {
        PixelReader reader = image.getPixelReader();
        WritableImage texture = new WritableImage(reader, (int)image.getWidth(), (int)image.getHeight());
        PixelWriter writer = texture.getPixelWriter();
        int x = 0;
        while ((double)x < texture.getWidth()) {
            int y = 0;
            while ((double)y < texture.getHeight()) {
                Color c = reader.getColor(x, y);
                if (c.getOpacity() != 0.0) {
                    writer.setColor(x, y, Color.rgb((int)((int)c.getRed()), (int)((int)c.getBlue()), (int)((int)c.getGreen()), (double)0.01));
                }
                ++y;
            }
            ++x;
        }
        return texture;
    }

    public static WritableImage colorize(Image image, Color color) {
        PixelReader reader = image.getPixelReader();
        WritableImage texture = new WritableImage(reader, (int)image.getWidth(), (int)image.getHeight());
        PixelWriter writer = texture.getPixelWriter();
        int x = 0;
        while ((double)x < texture.getWidth()) {
            int y = 0;
            while ((double)y < texture.getHeight()) {
                Color original = reader.getColor(x, y);
                double alpha = original.getOpacity();
                double brightness = original.getBrightness();
                if (alpha < 0.05 || brightness < 0.2) {
                    writer.setColor(x, y, original);
                } else {
                    Color tinted = new Color(color.getRed() * brightness, color.getGreen() * brightness, color.getBlue() * brightness, alpha);
                    writer.setColor(x, y, tinted);
                }
                ++y;
            }
            ++x;
        }
        return texture;
    }

    public static WritableImage combine(Image imageBelow, Image imageOver) {
        PixelReader readerBelow = imageBelow.getPixelReader();
        PixelReader readerOver = imageOver.getPixelReader();
        WritableImage texture = new WritableImage(readerBelow, (int)imageBelow.getWidth(), (int)imageBelow.getHeight());
        PixelWriter writer = texture.getPixelWriter();
        int x = 0;
        while ((double)x < texture.getWidth()) {
            int y = 0;
            while ((double)y < texture.getHeight()) {
                Color c1 = readerBelow.getColor(x, y);
                Color c2 = readerOver.getColor(x, y);
                writer.setColor(x, y, UtilTexture.combine(c1, c2));
                ++y;
            }
            ++x;
        }
        return texture;
    }

    public static Color combine(Color c1, Color c2) {
        double b;
        double g;
        double r;
        double a2;
        double a1 = c1.getOpacity();
        double a = a1 + (a2 = c2.getOpacity()) * (1.0 - a1);
        if (a != 0.0) {
            r = (c1.getRed() * a1 + c2.getRed() * a2 * (1.0 - a1)) / a;
            g = (c1.getGreen() * a1 + c2.getGreen() * a2 * (1.0 - a1)) / a;
            b = (c1.getBlue() * a1 + c2.getBlue() * a2 * (1.0 - a1)) / a;
        } else {
            b = 0.0;
            g = 0.0;
            r = 0.0;
        }
        return new Color(r, g, b, a);
    }

    private UtilTexture() {
    }
}

