/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import open.batoru.ImageCache;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.ui.UI;

public class AnimationBorderIcon
extends Transition {
    private static final int DURATION = 7500;
    private final Group3D border = new Group3D();
    private final List<BorderIcon> listIcons = new ArrayList<BorderIcon>();
    private Group3D root;
    private Zone zone;
    private Card3D card3D;
    private final int w;
    private final int h;
    private final int offset;
    private Group3D.OnVectorChangedHandler handlerTranslate;

    public AnimationBorderIcon(Zone zone, TargetFilter.TargetHint hintTargetType) {
        this(zone.isFlipped(), zone.getWidth(), zone.getHeight(), hintTargetType, 48, BorderType.INNER, 0);
        FieldZone fieldZone;
        this.zone = zone;
        if (zone instanceof FieldZone && FieldZone.isOccupied(fieldZone = (FieldZone)zone)) {
            this.card3D = zone.getTopCard();
        }
        this.border.setTranslate(zone.getNode());
        this.border.setTransZ(this.border.getTransZ() - 8.0);
        this.border.setRotate(zone.getNode());
    }

    public AnimationBorderIcon(Card3D card3D, TargetFilter.TargetHint hintTargetType) {
        this(card3D.getOwnerZone().isFlipped(), 250, 349, hintTargetType, 48, BorderType.OUTER, 40);
        this.card3D = card3D;
        this.border.setTranslate(card3D);
        this.border.setTransZ(card3D.localToScene(0.0, 0.0, 0.0).getZ() - 6.0);
        this.border.setRotate(card3D);
        if (!card3D.getOwnerZone().isFlipped() || card3D.getOwnerZone().getZoneLocation() != GameConst.CardLocation.HAND) {
            this.handlerTranslate = (x, y, z) -> this.border.setTranslate(x, y, z - 6.0);
            card3D.setOnTranslated(this.handlerTranslate);
        } else {
            this.border.setRotateX(-90.0);
            this.border.setTransY(this.border.getTransY() - 6.0);
            this.handlerTranslate = (x, y, z) -> this.border.setTranslate(x, y - 6.0, z - 6.0);
            card3D.setOnTranslated(this.handlerTranslate);
        }
    }

    public AnimationBorderIcon(boolean isFlipped, int areaWidth, int areaHeight, TargetFilter.TargetHint hintTargetType, int iconSize, BorderType borderType, int borderOffset) {
        this.setCycleDuration(Duration.millis((double)7500.0));
        this.setInterpolator(Interpolator.LINEAR);
        this.setCycleCount(-1);
        if (borderType == BorderType.OUTER) {
            areaWidth += borderOffset;
            areaHeight += borderOffset;
        } else {
            areaWidth -= borderOffset;
            areaHeight -= borderOffset;
        }
        this.w = areaWidth / 2;
        this.h = areaHeight / 2;
        this.offset = iconSize / 2;
        if (isFlipped) {
            this.border.setRotateZ(this.border.getRotateZ() + 180.0);
        }
        Image texture = ImageCache.INSTANCE.getImage(ImageCache.getBorderIconTexturePath(hintTargetType));
        this.createBorderIcons(iconSize, texture);
        this.border.setMouseTransparent(true);
        this.root = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByZoneFlip(isFlipped);
        this.root.getChildren().add((Object)this.border);
    }

    private void createBorderIcons(int iconSize, Image texture) {
        int totalIcons = 4 * (this.w + this.h) / iconSize - 4;
        for (int i = 0; i < totalIcons; ++i) {
            this.listIcons.add(new BorderIcon(iconSize, texture, i));
        }
        this.border.getChildren().addAll(this.listIcons);
    }

    protected void interpolate(double frac) {
        for (BorderIcon icon : this.listIcons) {
            icon.move(frac);
        }
    }

    public void play() {
        AnimationTracker.addRunningAnimation(this);
        super.play();
    }

    public void stop() {
        AnimationTracker.removeRunningAnimation(this);
        super.stop();
        this.listIcons.clear();
        if (this.card3D != null && this.handlerTranslate != null) {
            this.card3D.removeOnTranslatedHandler(this.handlerTranslate);
        }
        this.border.getChildren().clear();
        if (this.root != null) {
            this.root.getChildren().remove((Object)this.border);
        }
        this.card3D = null;
        this.zone = null;
        this.root = null;
    }

    public Zone getSourceZone() {
        return this.zone;
    }

    public Card3D getSourceCard3D() {
        return this.card3D;
    }

    public void colorize(Color color) {
        for (BorderIcon icon : this.listIcons) {
            icon.getMaterial().setDiffuseColor(color);
        }
    }

    public static AnimationBorderIcon findBorderByCard3D(List<AnimationBorderIcon> listAniBorder, Card3D card3D) {
        return listAniBorder.stream().filter(aniBorder -> aniBorder.getSourceCard3D() == card3D).findFirst().orElse(null);
    }

    public static void stopAll(List<AnimationBorderIcon> listAniBorder) {
        for (AnimationBorderIcon aniBorder : listAniBorder) {
            aniBorder.stop();
        }
    }

    public static void stopAll(Map<?, AnimationBorderIcon> mapAniBorder) {
        mapAniBorder.values().forEach(AnimationBorderIcon::stop);
    }

    public static enum BorderType {
        INNER,
        OUTER;

    }

    public class BorderIcon
    extends Plane {
        private final double WIDTH;
        private final double HEIGHT;
        private final double PERIMETER;
        private final double idOffset;

        public BorderIcon(int iconSize, Image texture, int id) {
            super(iconSize, texture);
            this.WIDTH = (AnimationBorderIcon.this.w - AnimationBorderIcon.this.offset) * 2;
            this.HEIGHT = (AnimationBorderIcon.this.h - AnimationBorderIcon.this.offset) * 2;
            this.PERIMETER = (this.WIDTH + this.HEIGHT) * 2.0;
            this.setRotate(AnimationBorderIcon.this.border);
            this.idOffset = id * iconSize;
        }

        public void move(double frac) {
            double y;
            double x;
            double position = (frac * this.PERIMETER + this.idOffset) % this.PERIMETER;
            if (position < this.WIDTH) {
                x = (double)(-AnimationBorderIcon.this.w + AnimationBorderIcon.this.offset) + position;
                y = -AnimationBorderIcon.this.h + AnimationBorderIcon.this.offset;
            } else if (position < this.WIDTH + this.HEIGHT) {
                x = AnimationBorderIcon.this.w - AnimationBorderIcon.this.offset;
                y = (double)(-AnimationBorderIcon.this.h + AnimationBorderIcon.this.offset) + (position - this.WIDTH);
            } else if (position < 2.0 * this.WIDTH + this.HEIGHT) {
                x = (double)(AnimationBorderIcon.this.w - AnimationBorderIcon.this.offset) - (position - this.WIDTH - this.HEIGHT);
                y = AnimationBorderIcon.this.h - AnimationBorderIcon.this.offset;
            } else {
                x = -AnimationBorderIcon.this.w + AnimationBorderIcon.this.offset;
                y = (double)(AnimationBorderIcon.this.h - AnimationBorderIcon.this.offset) - (position - 2.0 * this.WIDTH - this.HEIGHT);
            }
            this.setTranslate(x, y);
        }
    }
}

