/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import java.util.function.Supplier;
import javafx.animation.Interpolator;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.UtilRandom;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;
import open.batoru.game.animations.tracker.TrackableAnimation;
import open.batoru.ui.UI;

public class AnimationCardEmojiSpray
extends TrackableAnimation {
    private final Plane[] listEmojis;
    private final int[] listEmojiSpread;
    private final int[] listEmojiJump;
    private final int[] listEmojiRotate;
    private final double[] listEmojiSpreadAngle;
    private final Group3D node = new Group3D();
    private static final int DURATION = 1000;
    private static final int NUM_EMOJI_TYPES = 10;

    public AnimationCardEmojiSpray(Card3D card3D, int minCount, int maxCount, int minSpread, int maxSpread, int minRotate, int maxRotate, int minJump, int maxJump) {
        this(card3D, minCount, maxCount, minSpread, maxSpread, minRotate, maxRotate, minJump, maxJump, () -> ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("vtuber/emojis/" + UtilRandom.get_z(10))));
        this.setStaticCycleDuration(1000.0);
    }

    public AnimationCardEmojiSpray(Card3D card3D, int minCount, int maxCount, int minSpread, int maxSpread, int minRotate, int maxRotate, int minJump, int maxJump, Supplier<Image> imageSupplier) {
        this.setCycleDuration(1000.0);
        this.setInterpolator(Interpolator.EASE_OUT);
        int num = UtilRandom.get(minCount, maxCount);
        this.listEmojis = new Plane[num];
        this.listEmojiSpread = new int[num];
        this.listEmojiJump = new int[num];
        this.listEmojiRotate = new int[num];
        this.listEmojiSpreadAngle = new double[num];
        for (int i = 0; i < num; ++i) {
            Plane emoji = new Plane(72, imageSupplier.get());
            emoji.setMouseTransparent(true);
            emoji.setTransZ(-8.0);
            this.node.getChildren().add((Object)emoji);
            this.listEmojis[i] = emoji;
            this.listEmojiSpread[i] = UtilRandom.get(minSpread, maxSpread);
            this.listEmojiJump[i] = -UtilRandom.get(minJump, maxJump);
            this.listEmojiRotate[i] = UtilRandom.get(minRotate, maxRotate);
            this.listEmojiSpreadAngle[i] = Math.toRadians((double)i * (360.0 / (double)num));
        }
        Zone zone = card3D.getOwnerZone();
        this.node.setTranslate(card3D);
        if (maxJump == 0) {
            this.node.setTransZ(this.node.getTransZ() - 8.0);
        }
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(Zone.getZoneOwner(zone)).getChildren().add((Object)this.node);
        this.setOnAnimationFinished(() -> UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(Zone.getZoneOwner(zone)).getChildren().remove((Object)this.node));
    }

    public void colorize(Color color) {
        this.node.getChildren().forEach(emoji -> ((Plane)((Object)emoji)).getMaterial().setDiffuseColor(color));
    }

    protected void interpolate(double frac) {
        for (int i = 0; i < this.listEmojis.length; ++i) {
            Plane emoji = this.listEmojis[i];
            emoji.setTransX((double)this.listEmojiSpread[i] * Math.cos(this.listEmojiSpreadAngle[i]) * frac);
            emoji.setTransY((double)this.listEmojiSpread[i] * Math.sin(this.listEmojiSpreadAngle[i]) * frac);
            emoji.setTransZ((double)(this.listEmojiJump[i] * 4) * frac * (1.0 - frac));
            emoji.setRotateZ((double)this.listEmojiRotate[i] * frac);
        }
    }
}

