/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardLoader;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationCardMove
extends TrackableAnimation {
    private final Card3D card3D;
    private Zone zoneStart;
    private final Zone zoneEnd;
    private Vector3D originStart;
    private Vector3D originDiff;
    private int originSign = 1;
    private Vector3D rotationStart;
    private Vector3D rotationDiff;
    private Vector3D rotationOffset = Vector3D.ZERO;
    private final Zone.ZonePosition addPosition;
    private static final int DURATION = 500;

    public AnimationCardMove(Card3D card3D, Zone zoneEnd) {
        this(card3D, null, zoneEnd, Zone.ZonePosition.TOP);
    }

    public AnimationCardMove(Card3D card3D, Zone zoneEnd, Zone.ZonePosition addPosition) {
        this(card3D, null, zoneEnd, addPosition);
    }

    public AnimationCardMove(Card3D card3D, Zone zoneStart, Zone zoneEnd) {
        this(card3D, zoneStart, zoneEnd, Zone.ZonePosition.TOP);
    }

    public AnimationCardMove(Card3D card3D, Zone zoneStart, Zone zoneEnd, Zone.ZonePosition addPosition) {
        this.setCycleDuration(500.0);
        this.setInterpolator(Interpolator.EASE_OUT);
        this.card3D = card3D;
        this.zoneStart = zoneStart;
        this.zoneEnd = zoneEnd;
        this.addPosition = addPosition;
        this.setOnAnimationFinished(this::onAnimationFinished);
    }

    public void setDownedRotationOffset() {
        this.setRotationOffset(new Vector3D(0.0, 0.0, 90.0));
    }

    public void setRotationOffset(Vector3D rotationOffset) {
        this.rotationOffset = rotationOffset;
    }

    @Override
    public void play() {
        if (this.zoneStart == null) {
            this.zoneStart = this.card3D.getOwnerZone();
        }
        this.zoneStart.removeCardFromZoneList(this.card3D);
        this.zoneStart.updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_REMOVED);
        if (this.card3D.getCardIndex().getIndexedInstance() != null) {
            if (this.card3D.getCardIndex().getIndexedInstance().isState(512) && this.card3D.getCardIndex().getLocation() != GameConst.CardLocation.CHECK_ZONE) {
                this.originSign = -1;
            }
            if (!(this.zoneEnd.getZoneLocation() != GameConst.CardLocation.REVEALED && this.zoneEnd.getZoneLocation() != GameConst.CardLocation.CHECK_ZONE || !CardConst.CardType.isCardInHorizontalOrientation(this.card3D.getCardIndex().getCardReference().getType()) && CardLoader.getImageSetMaskType(this.card3D.getCardIndex().getImageSet()) != CardDataImageSet.MaskType.VERTICAL)) {
                this.setDownedRotationOffset();
            }
        }
        this.originStart = new Vector3D(this.card3D, Vector3D.VectorType.ORIGIN);
        if (this.originSign == 1) {
            this.originDiff = Vector3D.subtract(this.zoneEnd.getNextCardOrigin(this.addPosition), this.originStart);
        } else {
            this.originDiff = this.zoneEnd.getNextCardOriginAbsolute(this.zoneStart, this.addPosition);
            if (this.zoneEnd.isFlipped()) {
                this.originSign = 1;
            }
        }
        this.rotationStart = new Vector3D(this.card3D, Vector3D.VectorType.ROTATION);
        Vector3D rotationEnd = this.zoneEnd.getNextCardRotation(this.addPosition);
        this.rotationDiff = Vector3D.subtract(Vector3D.add(rotationEnd, this.rotationOffset), this.rotationStart);
        this.zoneEnd.prepareNextModifiedIndex(this.addPosition == Zone.ZonePosition.TOP ? this.zoneEnd.getTotalCards() : 0);
        this.card3D.showBack();
        this.card3D.showFace();
        if (Game.getCurrentGame().isNeutralPerspectiveGame() && this.card3D.getCardIndex().getIndexedInstance() == null && GameConst.CardLocation.isPlayerPrivate(this.zoneEnd.getZoneLocation())) {
            this.card3D.showAsPrivate(true);
        }
        this.zoneStart.prepareRearrangeAnimation(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_REMOVED, this.addPosition);
        this.zoneEnd.prepareRearrangeAnimation(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED, this.addPosition);
        if (!GameConst.CardLocation.isSIGNI(this.zoneStart.getZoneLocation()) || !GameConst.CardLocation.isSIGNI(this.zoneEnd.getZoneLocation())) {
            this.card3D.getCardMeshFace().clearTextureLayers();
            this.card3D.getCardMeshBack().clearTextureLayers();
        }
        super.play();
    }

    protected void interpolate(double frac) {
        this.zoneStart.interpolateRearrangeAnimation(frac);
        this.zoneEnd.interpolateRearrangeAnimation(frac);
        this.card3D.setTransX(this.originStart.getX() + this.originDiff.getX() * frac * (double)this.originSign);
        this.card3D.setTransY(this.originStart.getY() + this.originDiff.getY() * frac * (double)this.originSign);
        this.card3D.setTransZ(this.originStart.getZ() + this.originDiff.getZ() * frac);
        this.card3D.setRotate(this.rotationStart, this.rotationDiff, frac);
    }

    private void onAnimationFinished() {
        this.card3D.getCardIndex().setLocation(this.zoneEnd.getZoneLocation());
        this.card3D.getCardIndex().resetOverrideLocation();
        if (!(this.card3D.getCardIndex().getIndexedInstance() == null || GameConst.CardLocation.isSIGNI(this.zoneStart.getZoneLocation()) && GameConst.CardLocation.isSIGNI(this.zoneEnd.getZoneLocation()))) {
            this.card3D.getCardIndex().getIndexedInstance().resetStats();
        }
        if (GameConst.CardLocation.isPublic(this.zoneEnd.getZoneLocation())) {
            this.card3D.getCardIndex().markAsKnownByBothPlayers(true);
        }
        if (this.card3D.getCardIndex().getIndexedInstance() != null) {
            this.card3D.getCardIndex().setCardFace(CardConst.CardFace.FRONT);
        }
        if (Game.getCurrentGame().isNeutralPerspectiveGame() && this.card3D.getCardIndex().getIndexedInstance() == null && !GameConst.CardLocation.isPublic(this.zoneEnd.getZoneLocation()) && !GameConst.CardLocation.isPlayerPrivate(this.zoneEnd.getZoneLocation())) {
            this.card3D.hidePrivate();
        }
        this.zoneStart.setOnRearrangeAnimationInterpolate(null);
        this.zoneEnd.setOnRearrangeAnimationInterpolate(null);
        this.zoneEnd.addCardToZoneList(this.card3D, this.addPosition);
        this.zoneEnd.updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED);
    }
}

