/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.game._3d.Group3D;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationCardShatterFragment
extends TrackableAnimation {
    private final Group3D fragment;
    private static final int DURATION = 500;
    private final double startZ;
    private final double diffZ;

    public AnimationCardShatterFragment(Group3D fragment, boolean isDisassemble, boolean isFaceUp) {
        this.setCycleDuration(500 * (isDisassemble ? 1 : 2));
        this.setInterpolator(Interpolator.LINEAR);
        this.fragment = fragment;
        if (!isDisassemble) {
            fragment.setTransZ(fragment.getTransZ() - 2000.0);
        }
        this.startZ = fragment.getTransZ();
        double endZ = this.startZ - (double)(2000 * (isDisassemble && isFaceUp ? 1 : -1));
        this.diffZ = endZ - this.startZ;
    }

    protected void interpolate(double frac) {
        this.fragment.setTransZ(this.startZ + this.diffZ * frac);
    }
}

