/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.data.CardConst;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.EnerColor;
import open.batoru.game._3d.textures.ColorTextureLayer;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationEnerColorSelect
extends TrackableAnimation {
    private static final int DURATION = 100;
    private static final double COLOR_BRIGHTNESS = 0.815;
    private final double startX;
    private final double groupStartY;
    private final double distance;
    private final Card3D card3D;
    private final EnerColor enerColor;
    private final boolean forward;

    public AnimationEnerColorSelect(Card3D card3D, EnerColor enerColor, boolean forward) {
        this.setStaticCycleDuration(100.0);
        this.setInterpolator(Interpolator.EASE_OUT);
        this.distance = enerColor.getSourceEnerGroup().getEnerColorSize() / (double)(forward ? 2 : -2);
        this.card3D = card3D;
        this.enerColor = enerColor;
        this.forward = forward;
        this.startX = card3D.getTransX();
        this.groupStartY = enerColor.getSourceEnerGroup().getTransY();
    }

    @Override
    public void play() {
        if (this.forward) {
            this.card3D.getCardMeshFace().addTextureLayer(new ColorTextureLayer("ener_tint", CardConst.CardColor.utilCardColorToJavaFXColor(this.enerColor.getColor(), 1.0, 0.815)));
        } else {
            this.card3D.getCardMeshFace().removeTextureLayer("ener_tint");
        }
        super.play();
    }

    protected void interpolate(double frac) {
        this.card3D.setTransX(this.startX - this.distance * frac);
        this.enerColor.getSourceEnerGroup().setTransY(this.groupStartY + this.distance * frac);
    }
}

