/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.shape.Rectangle;
import open.batoru.ImageCache;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardLoader;
import open.batoru.data.ability.Ability;
import open.batoru.game.animations.tracker.TrackableAnimation;
import open.batoru.ui.UI;

public class AnimationFlashEffect
extends TrackableAnimation {
    private final AnchorPane node = new AnchorPane();
    private final ImageView image;
    private final Rectangle separator;
    private final int separatorStartY;
    private final int separatorEndY;
    public static final int DURATION = 1000;

    public AnimationFlashEffect(Ability ability) {
        this(ability.getSourceCardIndex(), ability.getCachedSourceCardImageSet());
    }

    public AnimationFlashEffect(CardIndex cardIndex) {
        this(cardIndex, null);
    }

    private AnimationFlashEffect(CardIndex cardIndex, String imageSetFallback) {
        this.setCycleDuration(1000.0);
        this.setInterpolator(Interpolator.LINEAR);
        this.node.setMinSize(250.0, 349.0);
        this.node.setMaxSize(250.0, 349.0);
        this.image = new ImageView(ImageCache.INSTANCE.getCardImage(cardIndex.getImageSet() != null ? cardIndex.getImageSet() : imageSetFallback));
        this.separator = new Rectangle(500.0, 80.0);
        this.separatorStartY = -254;
        this.separatorEndY = 778;
        if (cardIndex.getCardReference() == null || !CardConst.CardType.isCardInHorizontalOrientation(cardIndex.getCardReference().getType()) && CardLoader.getImageSetMaskType(cardIndex.getImageSet()) != CardDataImageSet.MaskType.VERTICAL) {
            this.separator.setRotate(-54.0);
        } else {
            this.separator.setRotate(54.0);
            this.image.setRotate(-180.0);
            this.node.setRotate(-90.0);
        }
        this.separator.setStyle("-fx-fill: linear-gradient(transparent 0%, white 40%, white 60%, transparent 100%);");
        Rectangle clip = new Rectangle(250.0, 349.0);
        clip.setArcWidth(26.0);
        clip.setArcHeight(26.0);
        this.node.setClip((Node)clip);
        this.node.setMouseTransparent(true);
        this.node.getChildren().addAll((Object[])new Node[]{this.image, this.separator});
        AnchorPane.setLeftAnchor((Node)this.separator, (Double)-125.0);
        UI.getTabGame().getFieldSceneOverlay().getNode().getChildren().add((Object)this.node);
        UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(cardIndex);
        this.setOnAnimationFinished(() -> UI.getTabGame().getFieldSceneOverlay().getNode().getChildren().remove((Object)this.node));
    }

    protected void interpolate(double frac) {
        AnchorPane.setTopAnchor((Node)this.separator, (Double)((double)this.separatorStartY + (double)this.separatorEndY * frac));
    }

    public final int getSeparatorStartY() {
        return this.separatorStartY;
    }

    public final int getSeparatorEndY() {
        return this.separatorEndY;
    }

    public final ImageView getNodeImage() {
        return this.image;
    }

    public final Rectangle getNodeSeparator() {
        return this.separator;
    }

    public final AnchorPane getNode() {
        return this.node;
    }
}

