/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.shape.Rectangle;
import open.batoru.ImageCache;
import open.batoru.game.animations.tracker.TrackableAnimation;
import open.batoru.ui.UI;

public class AnimationFlashGrow
extends TrackableAnimation {
    private final AnchorPane node = new AnchorPane();
    private final ImageView imageNew;
    private final Rectangle separator;
    public static final int DURATION = 1000;

    public AnimationFlashGrow(String imageSetOld, String imageSetNew) {
        this.setCycleDuration(1000.0);
        this.setInterpolator(Interpolator.LINEAR);
        this.node.setMinSize(250.0, 349.0);
        this.node.setMaxSize(250.0, 349.0);
        ImageView imageOld = new ImageView(ImageCache.INSTANCE.getCardImage(imageSetOld));
        this.imageNew = new ImageView(ImageCache.INSTANCE.getCardImage(imageSetNew));
        this.separator = new Rectangle(250.0, 60.0);
        this.separator.setStyle("-fx-fill: linear-gradient(transparent 0%, white 40%, white 60%, transparent 100%);");
        Rectangle clip = new Rectangle(250.0, 349.0);
        clip.setArcWidth(26.0);
        clip.setArcHeight(26.0);
        this.node.setClip((Node)clip);
        this.node.setMouseTransparent(true);
        this.node.getChildren().addAll((Object[])new Node[]{imageOld, this.imageNew, this.separator});
        UI.getTabGame().getFieldSceneOverlay().getNode().getChildren().add((Object)this.node);
        this.setOnAnimationFinished(() -> UI.getTabGame().getFieldSceneOverlay().getNode().getChildren().remove((Object)this.node));
    }

    protected void interpolate(double frac) {
        double currentHeight = 349.0 * frac;
        double currentY = 349.0 - currentHeight;
        this.imageNew.setViewport(new Rectangle2D(0.0, currentY, 250.0, currentHeight));
        AnchorPane.setTopAnchor((Node)this.imageNew, (Double)currentY);
        AnchorPane.setBottomAnchor((Node)this.separator, (Double)(currentHeight - 30.0));
    }
}

