/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import open.batoru.ImageCache;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.game.animations.AnimationFlashEffect;
import open.batoru.ui.UI;

public class AnimationFlashGuard
extends AnimationFlashEffect {
    private final StackPane node = new StackPane();
    private final ImageView imageGuard;
    private final Circle circle;

    public AnimationFlashGuard(CardIndex cardIndex) {
        super(cardIndex);
        this.node.setMinSize(250.0, 349.0);
        this.imageGuard = new ImageView(ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("guard")));
        this.imageGuard.setCacheHint(CacheHint.SCALE);
        this.circle = new Circle();
        this.circle.setFill((Paint)Color.TRANSPARENT);
        this.circle.setStroke((Paint)Color.WHITE);
        this.node.getChildren().addAll((Object[])new Node[]{this.circle, this.imageGuard});
        this.node.setMouseTransparent(true);
        UI.getTabGame().getFieldSceneOverlay().getNode().getChildren().add((Object)this.node);
        this.setOnAnimationFinished(() -> UI.getTabGame().getFieldSceneOverlay().getNode().getChildren().remove((Object)this.node));
    }

    @Override
    protected void interpolate(double frac) {
        super.interpolate(frac);
        this.imageGuard.setScaleX(0.4 + 1.4 * frac);
        this.imageGuard.setScaleY(0.4 + 1.4 * frac);
        this.circle.setRadius(280.0 * frac);
        this.circle.setOpacity(1.0 - frac);
        this.circle.setStrokeWidth(10.0 - 9.0 * frac);
    }
}

