/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import open.batoru.ImageCache;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.game.animations.tracker.TrackableAnimation;
import open.batoru.ui.UI;

public class AnimationFlashKey
extends TrackableAnimation {
    public static final int DURATION = 1000;
    private final ImageView imageTop;

    public AnimationFlashKey(CardIndex cardIndex, boolean isActive) {
        this.setCycleDuration(1000.0);
        this.setInterpolator(Interpolator.EASE_OUT);
        StackPane node = new StackPane();
        node.setMinSize(349.0, 250.0);
        node.setMaxSize(349.0, 250.0);
        ImageView imageCard = new ImageView(ImageCache.INSTANCE.getCardImage(cardIndex.getImageSet()));
        imageCard.setRotate(90.0);
        ImageView imageKeyBack = new ImageView(ImageCache.INSTANCE.getKeyCardBackImage());
        if (isActive) {
            node.getChildren().addAll((Object[])new Node[]{imageCard, imageKeyBack});
            this.imageTop = imageKeyBack;
        } else {
            node.getChildren().addAll((Object[])new Node[]{imageKeyBack, imageCard});
            this.imageTop = imageCard;
        }
        UI.getTabGame().getFieldSceneOverlay().getNode().getChildren().add((Object)node);
        UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(cardIndex);
        this.setOnAnimationFinished(() -> UI.getTabGame().getFieldSceneOverlay().getNode().getChildren().remove((Object)node));
    }

    protected void interpolate(double frac) {
        this.imageTop.setOpacity(1.0 - frac);
    }
}

