/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.game._3d.GizmoResona;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationGizmoResonaCircleMove
extends TrackableAnimation {
    private final GizmoResona.GizmoResonaCircle circle;
    private static final int DURATION = 1000;
    private final double startZ;
    private final double diffZ;
    private final double startAngleZ;

    public AnimationGizmoResonaCircleMove(GizmoResona.GizmoResonaCircle circle, boolean descend) {
        this.circle = circle;
        this.setCycleDuration(1000.0);
        this.setInterpolator(Interpolator.EASE_OUT);
        this.startZ = circle.getTransZ();
        this.diffZ = this.startZ + (double)(descend ? 0 : 2000);
        this.startAngleZ = circle.getRotateZ();
        this.setOnAnimationFinished(circle::markAsDescended);
    }

    protected void interpolate(double frac) {
        this.circle.setTransZ(this.startZ - this.diffZ * frac);
        this.circle.setRotateZ(this.startAngleZ + 180.0 * frac);
    }
}

