/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.UtilRandom;
import open.batoru.game._3d.GizmoResona;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationGizmoResonaCircleRotate
extends TrackableAnimation {
    private final GizmoResona gizmo;
    private int cacheNumDescended;
    private final double[] listAnglesStart;
    private final double[] listAnglesDiff;
    private static final int DURATION = 280;
    private static final double DURATION_FINAL_ACCEL = 150.0;
    private static final int ANGLE_DIFF_MIN = 10;
    private static final int ANGLE_DIFF_MAX = 30;

    public AnimationGizmoResonaCircleRotate(GizmoResona gizmo) {
        this.gizmo = gizmo;
        this.setInterpolator(Interpolator.LINEAR);
        this.listAnglesStart = new double[gizmo.getCirclesCount()];
        this.listAnglesDiff = new double[gizmo.getCirclesCount()];
    }

    @Override
    public void play() {
        this.setStaticCycleDuration(280.0 - 150.0 / (double)this.gizmo.getCirclesCount() * (double)this.gizmo.getDescendedCirclesCount());
        this.setDelay(this.getCycleDuration());
        int sign = UtilRandom.get_z(10) < 5 ? 1 : -1;
        this.cacheNumDescended = this.gizmo.getDescendedCirclesCount();
        for (int i = 0; i < this.cacheNumDescended; ++i) {
            this.listAnglesStart[i] = this.gizmo.getCircle(i).getRotateZ();
            this.listAnglesDiff[i] = UtilRandom.get(10, 30) * sign * (i % 2 == 0 ? 1 : -1);
        }
        super.play();
    }

    protected void interpolate(double frac) {
        for (int i = 0; i < this.cacheNumDescended; ++i) {
            this.gizmo.getCircle(i).setRotateZ(this.listAnglesStart[i] + this.listAnglesDiff[i] * frac);
        }
    }
}

