/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.game._3d.GizmoResona;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationGizmoResonaCircleRotateStop
extends TrackableAnimation {
    private final GizmoResona gizmo;
    private final double[] listAnglesStart;
    private final double[] listAnglesDiff;
    private static final int DURATION = 500;
    private static final int TURNS = 2;

    public AnimationGizmoResonaCircleRotateStop(GizmoResona gizmo) {
        this.gizmo = gizmo;
        this.setStaticCycleDuration(500.0);
        this.setInterpolator(Interpolator.EASE_IN);
        this.listAnglesStart = new double[gizmo.getCirclesCount()];
        this.listAnglesDiff = new double[gizmo.getCirclesCount()];
        for (int i = 0; i < gizmo.getCirclesCount(); ++i) {
            this.listAnglesStart[i] = gizmo.getCircle(i).getRotateZ();
            this.listAnglesDiff[i] = (this.listAnglesStart[i] + (double)((i % 2 == 0 ? -360 : 360) * 2)) % 360.0;
        }
    }

    protected void interpolate(double frac) {
        for (int i = 0; i < this.gizmo.getCirclesCount(); ++i) {
            this.gizmo.getCircle(i).setRotateZ(this.listAnglesStart[i] - this.listAnglesDiff[i] * frac);
        }
    }
}

