/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.ImageCache;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.Zone;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.MagicBoxLid;
import open.batoru.game.animations.AnimationCardEmojiSpray;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationMagicBox
extends TrackableAnimation {
    private final Group3D magicBoxLid;
    private final double startAngle;
    private final double diffAngle;
    private static final int DURATION = 500;

    public AnimationMagicBox(MagicBoxLid magicBoxLid, boolean isClosing) {
        this.setCycleDuration(500.0);
        this.setInterpolator(isClosing ? Interpolator.EASE_IN : Interpolator.EASE_OUT);
        this.magicBoxLid = magicBoxLid;
        this.startAngle = isClosing ? (double)(magicBoxLid.isLeft() ? 90 : -90) : 0.0;
        this.diffAngle = 90 * (isClosing ? 1 : -1) * (magicBoxLid.isLeft() ? 1 : -1);
    }

    public void interpolate(double frac) {
        this.magicBoxLid.setRotateY(this.startAngle - this.diffAngle * frac);
    }

    public static void playAnimations(CardIndex cardIndex, Zone zone, boolean isClosing) {
        MagicBoxLid lid1 = new MagicBoxLid(true);
        MagicBoxLid lid2 = new MagicBoxLid(false);
        lid1.addToZone(zone);
        lid2.addToZone(zone);
        AnimationMagicBox aniBox1 = new AnimationMagicBox(lid1, isClosing);
        AnimationMagicBox aniBox2 = new AnimationMagicBox(lid2, isClosing);
        if (!isClosing && cardIndex != null) {
            boolean hasLifeBurst = cardIndex.getIndexedInstance().findLifeBurstAbility().isPresent();
            AnimationCardEmojiSpray aniSpray = new AnimationCardEmojiSpray(cardIndex.getSourceCard3D(), 5, 5, 250, 250, 60, 360, 200, 250, () -> ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath(hasLifeBurst ? "lifeburst" : "magic_box/star")));
            if (!hasLifeBurst) {
                aniSpray.colorize(GameConst.CardUnderType.ZONE_MAGIC_BOX.getColor());
            }
            aniSpray.setOnAnimationFinished(() -> {
                lid1.removeFromZone();
                lid2.removeFromZone();
            });
            aniSpray.setDelay(100.0);
            aniSpray.play();
        } else {
            aniBox1.setOnAnimationFinished(() -> {
                lid1.removeFromZone();
                lid2.removeFromZone();
            });
        }
        aniBox1.play();
        aniBox2.play();
    }
}

