/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.game.FieldZoneSpinner;
import open.batoru.game._3d.Group3D;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationSpinnerRearrange
extends TrackableAnimation {
    private final FieldZoneSpinner spinner;
    private final double[] startAngle;
    private final double[] diffAngle;
    private final double[] startHeight;
    private static final int DURATION = 500;
    private static final int RADIUS = 180;
    private static final int HEIGHT_VARIANCE = 50;

    public AnimationSpinnerRearrange(FieldZoneSpinner spinner) {
        this.setStaticCycleDuration(500.0);
        this.setInterpolator(Interpolator.LINEAR);
        this.spinner = spinner;
        this.startAngle = new double[spinner.getListSpinNodes().size()];
        this.diffAngle = new double[spinner.getListSpinNodes().size()];
        this.startHeight = new double[spinner.getListSpinNodes().size()];
        for (int i = 0; i < spinner.getListSpinNodes().size(); ++i) {
            Group3D nodeSpin = spinner.getListSpinNodes().get(i);
            this.startAngle[i] = nodeSpin.getRotateY();
            this.startHeight[i] = nodeSpin.getTransZ();
            double endAngle = (float)i * (360.0f / (float)spinner.getListSpinNodes().size());
            this.diffAngle[i] = endAngle - this.startAngle[i];
        }
    }

    protected void interpolate(double frac) {
        for (int i = 0; i < this.spinner.getListSpinNodes().size(); ++i) {
            Group3D nodeSpin = this.spinner.getListSpinNodes().get(i);
            double angle = (this.startAngle[i] + this.diffAngle[i] * frac) % 360.0;
            double sin = Math.sin(Math.toRadians(angle));
            double cos = Math.cos(Math.toRadians(angle));
            nodeSpin.setTransX(sin * 180.0);
            nodeSpin.setTransY(cos * 180.0);
            nodeSpin.setTransZ(this.startHeight[i] + 50.0 * (sin * cos));
            nodeSpin.setRotateY(-angle);
            nodeSpin.setRotateZ(-angle);
        }
    }
}

