/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.util.Duration;
import open.batoru.game.FieldZoneSpinner;
import open.batoru.game._3d.Group3D;
import open.batoru.game.animations.tracker.AnimationTracker;

public class AnimationSpinnerRotate
extends Transition {
    private FieldZoneSpinner spinner;
    private double[] startAngle;
    private static final int DURATION = 5000;
    private static final int RADIUS = 180;
    private static final int HEIGHT_VARIANCE = 50;

    public AnimationSpinnerRotate() {
        this.setCycleDuration(Duration.millis((double)5000.0));
        this.setCycleCount(-1);
        this.setInterpolator(Interpolator.LINEAR);
    }

    public void setSpinner(FieldZoneSpinner spinner) {
        this.spinner = spinner;
        this.startAngle = new double[spinner.getListSpinNodes().size()];
        for (int i = 0; i < spinner.getListSpinNodes().size(); ++i) {
            Group3D nodeSpin = spinner.getListSpinNodes().get(i);
            this.startAngle[i] = nodeSpin.getRotateY();
        }
    }

    public void play() {
        AnimationTracker.addRunningAnimation(this);
        super.play();
    }

    public void stop() {
        AnimationTracker.removeRunningAnimation(this);
        super.stop();
    }

    protected void interpolate(double frac) {
        for (int i = 0; i < this.spinner.getListSpinNodes().size(); ++i) {
            Group3D nodeSpin = this.spinner.getListSpinNodes().get(i);
            double angle = (this.startAngle[i] + 360.0 * frac) % 360.0;
            double sin = Math.sin(Math.toRadians(angle));
            double cos = Math.cos(Math.toRadians(angle));
            nodeSpin.setTransX(sin * 180.0);
            nodeSpin.setTransY(cos * 180.0);
            nodeSpin.setTransZ(-64.0 + 50.0 * (sin * cos));
            nodeSpin.setRotateY(-angle);
            nodeSpin.setRotateZ(-angle);
        }
    }
}

