/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;
import open.batoru.game._3d.TexturedMesh;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationTexturedMeshFlash
extends TrackableAnimation {
    private final PhongMaterial meshTexture;
    private final Color colorStart;
    private final Color colorEnd;
    private static final int DURATION = 150;

    public AnimationTexturedMeshFlash(TexturedMesh mesh, Color colorStart, Color colorEnd, boolean autoReverse) {
        this(mesh, colorStart, colorEnd, autoReverse, 150);
    }

    public AnimationTexturedMeshFlash(TexturedMesh mesh, Color colorStart, Color colorEnd, boolean autoReverse, int duration) {
        this.setStaticCycleDuration(duration);
        this.setInterpolator(Interpolator.LINEAR);
        if (autoReverse) {
            this.setCycleCount(2);
            this.setAutoReverse(true);
        }
        this.meshTexture = mesh.getMaterial();
        this.colorStart = colorStart;
        this.colorEnd = colorEnd;
    }

    @Override
    public void stop() {
        super.stop();
        this.meshTexture.setDiffuseColor(this.colorStart);
    }

    protected void interpolate(double frac) {
        this.meshTexture.setDiffuseColor(this.colorStart.interpolate(this.colorEnd, frac));
    }
}

