/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations.tracker;

import java.util.ArrayList;
import javafx.animation.Transition;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationTracker {
    private static final ArrayList<Transition> listRunningAnimations = new ArrayList();
    private TrackableAnimationGenericHandler handlerAllFinished;
    private TrackableAnimationHandler handlerFinished;
    private int countFinished;
    private int countMax;
    private static boolean isStopping = false;

    public AnimationTracker(int countMax) {
        this.countMax = countMax;
    }

    public void setMaxCount(int countMax) {
        this.countMax = countMax;
        if (this.handlerAllFinished != null && countMax <= 0) {
            this.handlerAllFinished.handle();
        }
    }

    public int getMaxCount() {
        return this.countMax;
    }

    public int getFinishedCount() {
        return this.countFinished;
    }

    protected void countFinished(TrackableAnimation ani) {
        ++this.countFinished;
        if (this.handlerFinished != null) {
            this.handlerFinished.handle(ani);
        }
        if (this.handlerAllFinished != null && this.countFinished >= this.countMax) {
            this.handlerAllFinished.handle();
        }
    }

    public void setOnTrackerAllFinished(TrackableAnimationGenericHandler handler) {
        this.handlerAllFinished = handler;
    }

    public void setOnTrackerFinished(TrackableAnimationHandler handler) {
        this.handlerFinished = handler;
    }

    public static void addRunningAnimation(Transition transition) {
        if (!isStopping) {
            listRunningAnimations.add(transition);
        }
    }

    public static void removeRunningAnimation(Transition transition) {
        if (!isStopping) {
            listRunningAnimations.remove(transition);
        }
    }

    public static void stopAllRunningAnimations() {
        isStopping = true;
        listRunningAnimations.forEach(transition -> {
            transition.setOnFinished(null);
            transition.stop();
        });
        listRunningAnimations.clear();
        isStopping = false;
    }

    @FunctionalInterface
    public static interface TrackableAnimationGenericHandler {
        public void handle();
    }

    @FunctionalInterface
    public static interface TrackableAnimationHandler {
        public void handle(TrackableAnimation var1);
    }
}

