/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations.tracker;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.Transition;
import javafx.event.ActionEvent;
import javafx.util.Duration;
import open.batoru.core.Game;
import open.batoru.game.animations.tracker.AnimationTracker;

public abstract class TrackableAnimation
extends Transition {
    private AnimationTracker tracker;
    private AnimationTracker.TrackableAnimationGenericHandler handlerOnStarted;
    private List<AnimationTracker.TrackableAnimationGenericHandler> listHandlersOnFinished;

    public TrackableAnimation() {
        this.setOnFinished(this::internalOnAnimationFinished);
    }

    public void setOnAnimationStarted(AnimationTracker.TrackableAnimationGenericHandler handler) {
        this.handlerOnStarted = handler;
    }

    public void setOnAnimationFinished(AnimationTracker.TrackableAnimationGenericHandler handler) {
        if (this.listHandlersOnFinished == null) {
            this.listHandlersOnFinished = new ArrayList<AnimationTracker.TrackableAnimationGenericHandler>();
        }
        this.listHandlersOnFinished.add(handler);
    }

    public AnimationTracker.TrackableAnimationGenericHandler getOnAnimationStartedHandler() {
        return this.handlerOnStarted;
    }

    public void play() {
        AnimationTracker.addRunningAnimation(this);
        if (this.handlerOnStarted != null) {
            this.handlerOnStarted.handle();
        }
        super.play();
    }

    public void stop() {
        AnimationTracker.removeRunningAnimation(this);
        super.stop();
    }

    public void setCycleDuration(double millis) {
        this.setCycleDuration(Duration.millis((double)(millis * this.getGameSpeedMultiplier())));
    }

    public void setStaticCycleDuration(double millis) {
        this.setCycleDuration(Duration.millis((double)(this.getGameSpeedMultiplier() != 0.01 ? millis : 1.0)));
    }

    public void setDelay(double millis) {
        if (this.getGameSpeedMultiplier() == 0.01) {
            return;
        }
        this.setDelay(Duration.millis((double)millis));
    }

    private double getGameSpeedMultiplier() {
        return Game.getCurrentGame() == null ? 1.0 : Game.getCurrentGame().getGameSpeedController().getMultiplier();
    }

    private void internalOnAnimationFinished(ActionEvent e) {
        AnimationTracker.removeRunningAnimation(this);
        if (Game.getCurrentGame() == null) {
            return;
        }
        if (this.listHandlersOnFinished != null) {
            this.listHandlersOnFinished.forEach(AnimationTracker.TrackableAnimationGenericHandler::handle);
        }
        if (this.tracker != null) {
            this.tracker.countFinished(this);
        }
    }

    public void setAnimationTracker(AnimationTracker tracker) {
        this.tracker = tracker;
    }
}

